/*
 * Decompiled with CFR 0.152.
 */
package hotsun;

import hotsun.Filter;
import hotsun.HotSun;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Timers {
    public static final int SUN_DAMAGE = HotSun.config().getInt("sun-damage");
    public static List<String> worldValues = HotSun.config().getStringList("worlds-to-run-in");
    public static List<Integer> HOT_WORLDS = new ArrayList<Integer>();

    public static boolean isInHotWorld(Player player) {
        if (HOT_WORLDS.size() < 1) {
            for (String worldValue : worldValues) {
                int world = Integer.parseInt(worldValue);
                if (HOT_WORLDS.contains(world)) continue;
                System.out.println("HotSun running on world " + worldValue);
                HOT_WORLDS.add(world);
            }
        }
        return HOT_WORLDS.contains(player.getWorld().getEnvironment().getId());
    }

    public static boolean isDay() {
        World world = (World)Bukkit.getWorlds().get(0);
        return world.getTime() < 13884L || world.getTime() > 22634L;
    }

    public static void timer(final Plugin plugin) {
        for (Player player : plugin.getServer().getOnlinePlayers()) {
            if (!Timers.isInHotWorld(player) || player.isDead()) continue;
            Location location = player.getLocation();
            location.setY(location.getY() + 1.0);
            Block block = location.getBlock();
            if (block.getLightFromSky() <= 10 || block.getLightLevel() <= 9 || !Timers.isDay()) continue;
            ItemStack helmet = player.getInventory().getHelmet();
            if (!Objects.isNull(helmet)) {
                if (Filter.getDurability(helmet) > SUN_DAMAGE) {
                    Filter.setDurability(helmet, (short)(Filter.getDurability(helmet) - SUN_DAMAGE));
                    continue;
                }
                Filter.setDurability(helmet, (short)0);
                Timers.damagePlayer(player);
                continue;
            }
            Timers.damagePlayer(player);
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(plugin, new Runnable(){

            @Override
            public void run() {
                Timers.timer(plugin);
            }
        }, 20L);
    }

    public static void damagePlayer(Player player) {
        player.damage((double)SUN_DAMAGE);
        player.setFireTicks(60);
    }
}

