/*
 * Decompiled with CFR 0.152.
 */
package hotsun;

import hotsun.HotSun;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;

public class Filter
implements Listener {
    public static final String ITEM_NAME = HotSun.config().getString("filter.item-name");
    public static final String ITEM_DESCRIPTION = HotSun.config().getString("filter.item-description");
    public static final String DURABILITY_TITLE = HotSun.config().getString("filter.durability-title");
    public static final int MAX_DURABILITY = HotSun.config().getInt("filter.maximum-durability");
    ItemStack filter = new ItemStack(Material.LANTERN);
    ItemMeta filterMeta = this.filter.getItemMeta();

    public Filter() {
        this.filterMeta.setDisplayName(ChatColor.GOLD + ITEM_NAME);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(ChatColor.GOLD + ITEM_DESCRIPTION);
        this.filterMeta.setLore(lore);
        this.filter.setItemMeta(this.filterMeta);
        ShapedRecipe filterRecipe = new ShapedRecipe(HotSun.namespace, this.filter);
        RecipeChoice.MaterialChoice wools = new RecipeChoice.MaterialChoice(new Material[]{Material.WHITE_WOOL, Material.BLACK_WOOL, Material.GRAY_WOOL, Material.BROWN_WOOL, Material.LIGHT_GRAY_WOOL});
        filterRecipe.shape(new String[]{"WWW", "###", "S~S"});
        filterRecipe.setIngredient('#', Material.PAPER);
        filterRecipe.setIngredient('W', (RecipeChoice)wools);
        filterRecipe.setIngredient('~', Material.SUGAR_CANE);
        filterRecipe.setIngredient('S', Material.COAL_BLOCK);
        Bukkit.addRecipe((Recipe)filterRecipe);
    }

    public static boolean isFilter(ItemStack filter) {
        try {
            return filter.getItemMeta().getDisplayName().contains(ITEM_NAME);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static short getDurability(ItemStack helmet) {
        if (!helmet.getType().toString().contains("_HELMET")) {
            throw new IllegalArgumentException("Only a helmet can have " + DURABILITY_TITLE);
        }
        if (!helmet.getItemMeta().hasLore()) {
            return 0;
        }
        for (String lore : helmet.getItemMeta().getLore()) {
            if (!lore.contains(DURABILITY_TITLE)) continue;
            String[] lores = lore.split(" ");
            return Short.parseShort(lores[2]);
        }
        return 0;
    }

    public static boolean setDurability(ItemStack helmet, short durability) {
        if (durability > MAX_DURABILITY) {
            throw new IllegalArgumentException("Durability exceeds maximum");
        }
        if (durability < 0) {
            throw new IllegalArgumentException("Durability must be a positive amount");
        }
        if (!helmet.getType().toString().contains("_HELMET")) {
            throw new IllegalArgumentException("Filter can only be applied to a helmet");
        }
        if (helmet.getItemMeta().hasLore()) {
            List lores = helmet.getItemMeta().getLore();
            int index = -1;
            for (String lore : lores) {
                if (!lore.contains(DURABILITY_TITLE)) continue;
                index = lores.indexOf(lore);
            }
            if (index != -1) {
                lores.set(index, String.valueOf(DURABILITY_TITLE) + " " + durability + " / " + MAX_DURABILITY);
            } else {
                lores.add(ChatColor.YELLOW + DURABILITY_TITLE + ChatColor.WHITE + " " + durability + " / " + MAX_DURABILITY);
            }
            ItemMeta meta = helmet.getItemMeta();
            meta.setLore(lores);
            helmet.setItemMeta(meta);
            return true;
        }
        ArrayList<String> lores = new ArrayList<String>();
        lores.add(ChatColor.YELLOW + DURABILITY_TITLE + ChatColor.WHITE + " " + durability + " / " + MAX_DURABILITY);
        ItemMeta meta = helmet.getItemMeta();
        meta.setLore(lores);
        helmet.setItemMeta(meta);
        return true;
    }
}

