/*
 * Decompiled with CFR 0.152.
 */
package me.dutchwilco.HopperFilter.Listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Rotation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class EventListener
implements Listener {
    private List<Entity> getEntities(Location location, double x, double y, double z) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        result.addAll(location.getWorld().getNearbyEntities(location, -x, -y, -z));
        result.addAll(location.getWorld().getNearbyEntities(location, x, y, z));
        return result;
    }

    @EventHandler
    public void onItemMove(InventoryMoveItemEvent event) {
        if (event.getInitiator().equals(event.getDestination()) && event.getInitiator().getType().equals((Object)InventoryType.HOPPER)) {
            Inventory hopper = event.getInitiator();
            Location sourceLocation = event.getSource().getLocation();
            Collection closeEntities = sourceLocation.getWorld().getNearbyEntities(sourceLocation, 1.2, 1.2, 1.2);
            ArrayList<ItemStack> filterInItems = new ArrayList<ItemStack>();
            ArrayList<ItemStack> filterOutItems = new ArrayList<ItemStack>();
            for (Entity closeEntity : closeEntities) {
                if (!(closeEntity instanceof ItemFrame)) continue;
                ItemFrame itemFrame = (ItemFrame)closeEntity;
                if (!closeEntity.getType().equals((Object)EntityType.ITEM_FRAME) || !closeEntity.getLocation().getBlock().getRelative(itemFrame.getAttachedFace()).equals(hopper.getLocation().getBlock())) continue;
                if (itemFrame.getRotation() == Rotation.CLOCKWISE_45 || itemFrame.getRotation() == Rotation.CLOCKWISE_135 || itemFrame.getRotation() == Rotation.FLIPPED_45 || itemFrame.getRotation() == Rotation.COUNTER_CLOCKWISE_45) {
                    filterOutItems.add(itemFrame.getItem());
                    continue;
                }
                filterInItems.add(itemFrame.getItem());
            }
            if (!(filterInItems.contains(new ItemStack(Material.AIR)) || filterOutItems.contains(new ItemStack(Material.AIR)) || this.inFilter(filterInItems, event.getItem()) && this.inFilter(filterOutItems, event.getItem()) || !this.inFilter(filterOutItems, event.getItem()) && (this.inFilter(filterInItems, event.getItem()) || filterInItems.size() == 0))) {
                event.setCancelled(true);
                for (ItemStack sourceItem : event.getSource().getContents()) {
                    if (sourceItem == null || !this.inFilter(filterInItems, sourceItem) || this.inFilter(filterOutItems, sourceItem) || this.inFilter(filterInItems, sourceItem) && this.inFilter(filterOutItems, sourceItem)) continue;
                    ItemStack outItem = new ItemStack(sourceItem);
                    outItem.setAmount(1);
                    event.getInitiator().addItem(new ItemStack[]{outItem});
                    sourceItem.setAmount(sourceItem.getAmount() - 1);
                    break;
                }
            }
        }
    }

    private boolean inFilter(List<ItemStack> items, ItemStack eItem) {
        return items.size() != 0 && items.stream().anyMatch(item -> item.getType() != Material.AIR && (item.isSimilar(eItem) || item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().equalsIgnoreCase("fuzzy") && item.getType() == eItem.getType()));
    }
}

