package com.tsuser.honestshop;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

/**
 * Handles the author join admin announcement and anything that happens when a player joins the server for this plugin.
 * @author Tsuser1
 */
public class ListenerJoin implements Listener {
	private final HonestShop pl;
	
	public ListenerJoin(HonestShop plugin){
		this.pl = plugin;
	}
	
	@EventHandler
	public void playerJoinEvent(PlayerJoinEvent event){
		Bukkit.getLogger().info("player joined event fired");
		Player player = event.getPlayer();
		if(pl.getConfig().getBoolean("general.author-join-msg")){
			Bukkit.getLogger().info("config has event for join enabled");
			Bukkit.getLogger().info("uuid in event is " + player.getUniqueId().toString());
			if(player.getUniqueId().toString().equals("942ebd1f-cbc4-47b4-bf4f-f7cd897444fb")){
				Bukkit.broadcast(pl.msgPrefix + "The author of HonestShop, " + player.getName() + ", has joined!", "hs.admin");
				player.sendMessage(pl.msgPrefix + "Running HonestShop v" + pl.getDescription().getVersion());
			}
		} else {
			if(player.getUniqueId().toString().equals("942ebd1f-cbc4-47b4-bf4f-f7cd897444fb")){
				player.sendMessage(pl.msgPrefix + "Hey " + player.getName() + ", running HonestShop v" + pl.getDescription().getVersion());
				player.sendMessage(pl.msgPrefix + "The author join annoucement is disabled.");
			}
		}
	}
	
}
