package com.tsuser.honestshop;
/*
 * (C) 2017 Tanner H. (Tsuser). All rights reserved.
 * Redistribution not permitted, please provide a link to the plugin page to share. (Both available below)
 * DevBukkit: https://dev.bukkit.org/projects/honestshop
 * SpigotMC: https://www.spigotmc.org/resources/honestshop.41395/
 * 
 * All contributions and suggestions are welcome for this simple plugin
 * 
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   HONESTSHOP
 *    "Honestly, it's time to get honest with our shops!"
 *    HonestShop is a plugin aimed at reducing the number of
 *    scams done via the chest based economy. I'm tired of
 *    the scams, you're tired of the scams, it's time we made
 *    a change; this change now has a name: HonestShop.
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

import net.md_5.bungee.api.ChatColor;

import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

/**
 * HonestShop plugin main class, there's nothing really useful here.
 * @author Tsuser1
 * @version 2.7.1-PREA
 */
public final class HonestShop extends JavaPlugin {
	
	/*
	 *  Note to developers editing my code, please only edit this.
	 *  I wrote this plugin and decided to include it to make your
	 *  life easier, my only request is that you don't change any
	 *  of the messages giving me credit for the plugin. Thanks
	 */
	public final String logPrefix = "HonestShop: ";
	public String msgPrefix = "[HonestShop] "; // This is overwritten by the config option in plugin startup, this is just in case.
	
	@Override
	public void onEnable(){
		// Do configuration stuff
		this.saveDefaultConfig();
		
		// Custom prefix credit nagger
		if(!getConfig().getString("general.prefix").contains("Honest")){ // Yes a very simple check but its VERY effective.
			Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + logPrefix + "You're using a custom prefix for HonestShop. Be *honest* and remember to give the author credit!");
		}
		
		// Override the message prefix and catch errors
		updatePrefix();
		
		// Define executors
		this.getCommand("hscheck").setExecutor(new CommandCheck(this));
		this.getCommand("hsview").setExecutor(new CommandView(this));
		this.getCommand("honestshop").setExecutor(new CommandHonestShop(this));
		
		// Register events
		getServer().getPluginManager().registerEvents(new ListenerJoin(this), this);
		
		// We're done! Dump that goodness to the console!
		info("The HonestShop plugin has completed intialization, ready to run!");
	}
	
	@Override
	public void onDisable(){
		//TODO: Add things that happen on plugin disable
		info("The HonestShop plugin was disabled.");
	}
	
	// Helper functions...
	
	/**
	 * Send an INFO message to the console.
	 * @param message Message to send the console
	 * @version 1.0.0
	 */
	public void info(String message){
		getLogger().info(logPrefix + message);
	}
	
	/**
	 * Update the plugin's prefix from the configuration.
	 * @version 1.0.0
	 */
	public void updatePrefix(){
		try{
			msgPrefix = ChatColor.translateAlternateColorCodes('&', getConfig().getString("general.prefix"));
		} catch(Exception e) {
			if(!msgPrefix.contains("HonestShop")){ // Reset it to something we can work with if not already
				msgPrefix = "[HonestShop] ";
			}
			getLogger().severe("A critical error was encountered while reading the configuration for the prefix!");
			getLogger().severe("Java message: " + e.getMessage());
			getLogger().severe("Stack trace: " + e.getStackTrace());
		}
	}
}
