package com.tsuser.honestshop;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;

/**
 * Handler for the HonestShop view command
 * @version 4.1.0-A
 */
public class CommandView implements CommandExecutor {
	private final HonestShop pl;
	
	public CommandView(HonestShop plugin){
		this.pl = plugin;
	}
	
	@Override
	public boolean onCommand(CommandSender sender, Command command, String alias,
			String[] args) {
		if(!pl.isEnabled()){
			return false;
		}
		if(sender.hasPermission(command.getPermission()) && (sender instanceof Player)){
			execute(sender, command, alias, args);
			return true;
		} else if(!(sender instanceof Player)) { // ELSE IF: (Sender is not a Player)
			sender.sendMessage(pl.msgPrefix + "Only players can execute this command!");
			return true; // Because we did something.
		} else { // ELSE: Player lacks the permission for the command and is a player
			sender.sendMessage(pl.msgPrefix + command.getPermissionMessage());
			return true; // Because we did something. (Permission error)
		}
	}
	
	public void execute(CommandSender sender, Command command, String alias, String[] args){
		Player senderp = Bukkit.getPlayer(sender.getName());
		Block target = getTargetBlock(senderp, 5);
		if(target.getType().equals(Material.WALL_SIGN) || target.getType().equals(Material.SIGN_POST)){
			sender.sendMessage(pl.msgPrefix + "bThe sign at 7" + target.getLocation().getBlockX() + " " + target.getLocation().getBlockY() + " " + target.getLocation().getBlockZ() + "b reads..");
			Sign starget = (Sign) target.getState();
			for(int i = 0; i<4; i++){
				if(!starget.getLine(i).isEmpty()){
					sender.sendMessage(pl.msgPrefix + "bLine " + (i+1) + ":r " + starget.getLine(i));
				} else {
					sender.sendMessage(pl.msgPrefix + "bLine " + (i+1) + " 7ois blank.");
				}
			}
		} else {
			sender.sendMessage(pl.msgPrefix + "cThat reads.. Hey, wait a minute.. oThat's not a sign!");
		}
		
	}

	/**
	 * Custom getTargetBlock function to ignore transparent and non-collision blocks, only looks for signs.
	 * @param player Target player
	 * @param range How far to look for a sign
	 * @return Block Sign (if found), or null
	 */
	private final Block getTargetBlock(Player player, int range) {
	        BlockIterator iter = new BlockIterator(player, range);
	        Block lastBlock = iter.next();
	        while (iter.hasNext()) {
	            lastBlock = iter.next();
	            if ((lastBlock.getType().isTransparent() || !lastBlock.getType().isOccluding()) && (!lastBlock.getType().equals(Material.WALL_SIGN) && !lastBlock.getType().equals(Material.SIGN_POST))) {
	                continue;
	            }
	            break;
	        }
	        return lastBlock;
	    }
}
