package com.tsuser.honestshop;

import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

/**
 * Handler for the HonestShop view command
 * @version 1.2.0
 */
public class CommandHonestShop implements CommandExecutor {
	private final HonestShop pl;
	
	public CommandHonestShop(HonestShop plugin){
		this.pl = plugin;
	}
	
	@Override
	public boolean onCommand(CommandSender sender, Command command, String alias,
			String[] args) {
		if(!pl.isEnabled()){
			return false;
		}
		if(sender.hasPermission(command.getPermission())){
			if(!(args.length == 1)){
				sender.sendMessage(pl.msgPrefix + "cImproper syntax!");
			} else {
				switch (args[0]){
				case "version":
					sender.sendMessage(pl.msgPrefix + "eCurrently running HonestShop 7v" + pl.getDescription().getVersion() + "e!");
					sender.sendMessage(pl.msgPrefix + "eThe plugin author is 7Tsuser1e.");
				break;
				case "reload":
					try{
						pl.reloadConfig();
					} catch(Exception e) {
						pl.getLogger().severe("A critical error was encountered while reading the configuration!");
						pl.getLogger().severe("Java message: " + e.getMessage());
						pl.getLogger().severe("Stack trace: " + e.getStackTrace());
					}
					pl.updatePrefix();
					sender.sendMessage(pl.msgPrefix + "aReloaded configuration for HonestShop!");
				break;
				case "help":
					sender.sendMessage(pl.msgPrefix + "Commands available:");
					sender.sendMessage(pl.msgPrefix + "7/honestshop reload");
					sender.sendMessage(pl.msgPrefix + "7/honestshop version");
				break;
				default:
					sender.sendMessage(pl.msgPrefix + "cThat isn't a valid subcommand!");
				break;
				}
			}
		} else {
			sender.sendMessage(pl.msgPrefix + command.getPermissionMessage());
		}
		return true;
	}

}