/*
 * Decompiled with CFR 0.152.
 */
package hexagonstore.crates.utils.language.configuration;

import hexagonstore.crates.utils.EC_Config;
import hexagonstore.crates.utils.language.Language;
import hexagonstore.crates.utils.language.type.LanguageType;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageUtil {
    private Language language;
    private EC_Config portugueseConfig;
    private EC_Config englishConfig;

    public void load(JavaPlugin main) {
        this.portugueseConfig = new EC_Config(main, "langs", "pt-BR.yml", false);
        this.englishConfig = new EC_Config(main, "langs", "en-US.yml", false);
    }

    public EC_Config getIdiomConfig() {
        return this.language.getConfig();
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String getMessage(String path) {
        return this.language.getConfig().getString(this.language.getMessagePath() + path).replace("&", "\u00a7");
    }

    public List<String> getListMessage(String path) {
        return this.language.getConfig().getStringList(this.language.getMessagePath() + path).stream().map(line -> line.replace("&", "\u00a7")).collect(Collectors.toList());
    }

    public LanguageType getCurrentIdiom() {
        return this.language.getIdiom();
    }

    public Language getLanguage() {
        return this.language;
    }

    public EC_Config getPortugueseConfig() {
        return this.portugueseConfig;
    }

    public EC_Config getEnglishConfig() {
        return this.englishConfig;
    }
}

