/*
 * Decompiled with CFR 0.152.
 */
package hexagonstore.crates.utils;

import hexagonstore.crates.CratesPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Scroller {
    private String name;
    private int size;
    private List<ItemStack> items;
    private BiConsumer<Player, ItemStack> onChooseItem;
    private int nextPageSlot;
    private int previousPageSlot;
    private ItemStack nextPageItem;
    private ItemStack previousPageItem;
    private HashMap<Integer, ItemStack> customItems;
    private HashMap<Integer, Consumer<Player>> customItemActions;
    private List<Integer> allowedSlots;
    private HashMap<Integer, Inventory> pages;
    private int backSlot;
    private ItemStack backItem;
    private Consumer<Player> backConsumer;

    private Scroller(Builder builder) {
        this.name = builder.name;
        this.size = builder.size;
        this.items = builder.items;
        this.onChooseItem = builder.onChooseItem;
        this.nextPageSlot = builder.nextPageSlot;
        this.previousPageSlot = builder.previousPageSlot;
        this.nextPageItem = builder.nextPageItem;
        this.previousPageItem = builder.previousPageItem;
        this.customItems = builder.customItems;
        this.customItemActions = builder.customItemActions;
        this.allowedSlots = builder.allowedSlots;
        this.backSlot = builder.backSlot;
        this.backItem = builder.backItem;
        this.backConsumer = builder.backConsumer;
        this.pages = new HashMap();
        this.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private void build() {
        if (this.items.isEmpty()) {
            Inventory inventory = Bukkit.createInventory((InventoryHolder)new Holder(this, 1), (int)this.size, (String)this.name);
            if (this.backSlot != -1) {
                inventory.setItem(this.backSlot, this.backItem);
            }
            this.customItems.forEach((arg_0, arg_1) -> ((Inventory)inventory).setItem(arg_0, arg_1));
            this.pages.put(1, inventory);
            return;
        }
        List<List<ItemStack>> lists = this.getPages(this.items, this.allowedSlots.size());
        int page = 1;
        for (List<ItemStack> list : lists) {
            Inventory inventory = Bukkit.createInventory((InventoryHolder)new Holder(this, page), (int)this.size, (String)this.name);
            int slot = 0;
            for (ItemStack it : list) {
                inventory.setItem(this.allowedSlots.get(slot).intValue(), it);
                ++slot;
            }
            this.customItems.forEach((arg_0, arg_1) -> ((Inventory)inventory).setItem(arg_0, arg_1));
            inventory.setItem(this.previousPageSlot, this.editItem(this.previousPageItem.clone(), page - 1));
            inventory.setItem(this.nextPageSlot, this.editItem(this.nextPageItem.clone(), page + 1));
            if (this.backSlot != -1) {
                inventory.setItem(this.backSlot, this.backItem);
            }
            this.pages.put(page, inventory);
            ++page;
        }
        this.pages.get(1).setItem(this.previousPageSlot, new ItemStack(Material.AIR));
        this.pages.get(this.pages.size()).setItem(this.nextPageSlot, new ItemStack(Material.AIR));
    }

    private ItemStack editItem(ItemStack item, int page) {
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(item.getItemMeta().getDisplayName().replace("@page", page + ""));
        item.setItemMeta(meta);
        return item;
    }

    private <T> List<List<T>> getPages(Collection<T> c, Integer pageSize) {
        ArrayList<T> list = new ArrayList<T>(c);
        if (pageSize == null || pageSize <= 0 || pageSize > list.size()) {
            pageSize = list.size();
        }
        int numPages = (int)Math.ceil((double)list.size() / (double)pageSize.intValue());
        ArrayList<List<T>> pages = new ArrayList<List<T>>(numPages);
        int pageNum = 0;
        while (pageNum < numPages) {
            pages.add(list.subList(pageNum * pageSize, Math.min(++pageNum * pageSize, list.size())));
        }
        return pages;
    }

    public int getTotalPages() {
        return this.pages.size();
    }

    private boolean hasPage(int page) {
        return this.pages.containsKey(page);
    }

    public void open(Player player) {
        this.open(player, 1);
    }

    public void open(Player player, int page) {
        player.openInventory(this.pages.get(page));
    }

    private BiConsumer<Player, ItemStack> getOnChooseItem() {
        return this.onChooseItem;
    }

    private int getNextPageSlot() {
        return this.nextPageSlot;
    }

    private int getPreviousPageSlot() {
        return this.previousPageSlot;
    }

    private List<Integer> getAllowedSlots() {
        return this.allowedSlots;
    }

    private HashMap<Integer, Consumer<Player>> getCustomItemActions() {
        return this.customItemActions;
    }

    public HashMap<Integer, Inventory> getPages() {
        return this.pages;
    }

    private int getBackSlot() {
        return this.backSlot;
    }

    private Consumer<Player> getBackConsumer() {
        return this.backConsumer;
    }

    static {
        CratesPlugin plugin = CratesPlugin.getPlugin();
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onClick(InventoryClickEvent e) {
                if (e.getSlotType() == InventoryType.SlotType.OUTSIDE || e.getCurrentItem() == null) {
                    return;
                }
                if (e.getInventory().getHolder() instanceof Holder) {
                    e.setCancelled(true);
                    Holder holder = (Holder)e.getInventory().getHolder();
                    Scroller scroller = holder.getScroller();
                    Player player = (Player)e.getWhoClicked();
                    if (scroller.getBackSlot() == e.getSlot()) {
                        scroller.getBackConsumer().accept(player);
                    } else if (scroller.getCustomItemActions().containsKey(e.getSlot())) {
                        ((Consumer)scroller.getCustomItemActions().get(e.getSlot())).accept(player);
                    } else if (scroller.getNextPageSlot() == e.getSlot()) {
                        if (scroller.hasPage(holder.getPage() + 1)) {
                            scroller.open(player, holder.getPage() + 1);
                        }
                    } else if (scroller.getPreviousPageSlot() == e.getSlot()) {
                        if (scroller.hasPage(holder.getPage() - 1)) {
                            scroller.open(player, holder.getPage() - 1);
                        }
                    } else if (scroller.getAllowedSlots().contains(e.getSlot()) && e.getCurrentItem().getType() != Material.AIR) {
                        holder.getScroller().getOnChooseItem().accept(player, e.getCurrentItem());
                    }
                }
            }
        }, (Plugin)plugin);
    }

    private static final class Holder
    implements InventoryHolder {
        private Scroller scroller;
        private int page;

        public Holder(Scroller scroller, int page) {
            this.scroller = scroller;
            this.page = page;
        }

        public int getPage() {
            return this.page;
        }

        public Scroller getScroller() {
            return this.scroller;
        }

        public Inventory getInventory() {
            return null;
        }
    }

    public static final class Builder {
        private static final List<Integer> ALLOWED_SLOTS = Arrays.asList(10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34);
        private String name = "";
        private int size = 45;
        private List<ItemStack> items = new ArrayList<ItemStack>();
        private BiConsumer<Player, ItemStack> onChooseItem = (player, item) -> {};
        private int nextPageSlot = 26;
        private int previousPageSlot = 18;
        private ItemStack nextPageItem;
        private ItemStack previousPageItem;
        private int backSlot = -1;
        private ItemStack backItem;
        private Consumer<Player> backConsumer;
        private HashMap<Integer, ItemStack> customItems = new HashMap();
        private HashMap<Integer, Consumer<Player>> customItemActions = new HashMap();
        private List<Integer> allowedSlots = ALLOWED_SLOTS;

        private Builder() {
            this.backConsumer = player -> {};
            this.backItem = this.getBackFlecha();
            this.nextPageItem = this.getPageFlecha();
            this.previousPageItem = this.getBackFlecha();
        }

        private ItemStack getBackFlecha() {
            ItemStack item = new ItemStack(Material.ARROW);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(ChatColor.RED + "P\u00e1gina anterior");
            item.setItemMeta(meta);
            return item;
        }

        private ItemStack getPageFlecha() {
            ItemStack item = new ItemStack(Material.ARROW);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(ChatColor.GREEN + "Pr\u00f3xima p\u00e1gina");
            item.setItemMeta(meta);
            return item;
        }

        public Builder withBackItem(int backSlot, ItemStack backItem, Consumer<Player> player) {
            this.backItem = backItem;
            this.backSlot = backSlot;
            this.backConsumer = player;
            return this;
        }

        public Builder withBackItem(int backSlot, Consumer<Player> player) {
            this.backSlot = backSlot;
            this.backConsumer = player;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withSize(int size) {
            this.size = size;
            return this;
        }

        public Builder withItems(List<ItemStack> items) {
            this.items = items;
            return this;
        }

        public Builder withOnChooseItem(BiConsumer<Player, ItemStack> onChooseItem) {
            this.onChooseItem = onChooseItem;
            return this;
        }

        public Builder withNextPageSlot(int nextPageSlot) {
            this.nextPageSlot = nextPageSlot;
            return this;
        }

        public Builder withPreviousPageSlot(int previousPageSlot) {
            this.previousPageSlot = previousPageSlot;
            return this;
        }

        public Builder withNextPageItem(ItemStack nextPageItem) {
            this.nextPageItem = nextPageItem;
            return this;
        }

        public Builder withPreviousPageItem(ItemStack previousPageItem) {
            this.previousPageItem = previousPageItem;
            return this;
        }

        public Builder withCustomItem(int slot, ItemStack item) {
            this.customItems.put(slot, item);
            return this;
        }

        public Builder withCustomItem(int slot, ItemStack item, Consumer<Player> action) {
            this.customItems.put(slot, item);
            this.customItemActions.put(slot, action);
            return this;
        }

        public Builder withAllowedSlots(List<Integer> allowedSlots) {
            this.allowedSlots = allowedSlots;
            return this;
        }

        public Scroller build() {
            return new Scroller(this);
        }
    }
}

