/*
 * Decompiled with CFR 0.152.
 */
package hexagonstore.crates.utils;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class EC_Config {
    private JavaPlugin main;
    private boolean isNewFile;
    private File currentDirectory;
    private File file;
    private FileConfiguration fileConfig;

    public EC_Config(JavaPlugin main, String directory, String fileName, boolean isNewFile) {
        this.main = main;
        this.isNewFile = isNewFile;
        this.createDirectory(directory);
        this.createFile(directory, fileName);
        this.fileConfig = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void createDirectory(String directory) {
        this.currentDirectory = this.main.getDataFolder();
        if (directory != null) {
            this.currentDirectory = new File(this.main.getDataFolder(), directory.replace("/", File.separator));
            this.currentDirectory.mkdirs();
        }
    }

    public void createFile(String directory, String fileName) {
        this.file = new File(this.currentDirectory, fileName);
        if (!this.file.exists()) {
            if (this.isNewFile) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                this.main.saveResource(directory != null ? directory + File.separator + fileName : fileName, false);
            }
        }
    }

    public FileConfiguration getConfig() {
        return this.fileConfig;
    }

    public void saveConfig() {
        try {
            this.fileConfig.save(this.file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void reloadConfig() {
        this.fileConfig.setDefaults((Configuration)YamlConfiguration.loadConfiguration((File)this.file));
    }

    public String getString(String path) {
        return this.getConfig().getString(path);
    }

    public short getShort(String path) {
        return (short)this.getConfig().getInt(path);
    }

    public int getInt(String path) {
        return this.getConfig().getInt(path);
    }

    public boolean getBoolean(String path) {
        return this.getConfig().getBoolean(path);
    }

    public double getDouble(String path) {
        return this.getConfig().getDouble(path);
    }

    public List<?> getList(String path) {
        return this.getConfig().getList(path);
    }

    public boolean contains(String path) {
        return this.getConfig().contains(path);
    }

    public void set(String path, Object value) {
        this.getConfig().set(path, value);
    }

    public List<String> getStringList(String path) {
        return this.getConfig().getStringList(path);
    }

    public List<Integer> getIntegerList(String path) {
        return this.getConfig().getIntegerList(path);
    }

    public List<Double> getDoubleList(String path) {
        return this.getConfig().getDoubleList(path);
    }

    public List<Boolean> getBooleanList(String path) {
        return this.getConfig().getBooleanList(path);
    }

    public List<Byte> getByteList(String path) {
        return this.getConfig().getByteList(path);
    }

    public List<Character> getCharacterList(String path) {
        return this.getConfig().getCharacterList(path);
    }

    public List<Long> getLongList(String path) {
        return this.getConfig().getLongList(path);
    }

    public List<Short> getShortList(String path) {
        return this.getConfig().getShortList(path);
    }

    public List<Map<?, ?>> getMapList(String path) {
        return this.getConfig().getMapList(path);
    }

    public List<?> getList(String path, List<?> def) {
        return this.getConfig().getList(path, def);
    }

    public ConfigurationSection getConfigurationSection(String path) {
        return this.getConfig().getConfigurationSection(path);
    }
}

