/*
 * Decompiled with CFR 0.152.
 */
package hexagonstore.crates.models;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import hexagonstore.crates.CratesPlugin;
import hexagonstore.crates.models.Crate;
import hexagonstore.crates.utils.SkullURL;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CrateSpawned {
    private final Crate crate;
    private Location loc;
    private String playerOpening;
    private Hologram hologram;

    public CrateSpawned(Crate crate, Location loc) {
        this.crate = crate;
        this.loc = loc;
    }

    public boolean hasOpening() {
        return this.playerOpening != null;
    }

    public boolean isOpening(String playerName) {
        if (this.playerOpening == null) {
            return false;
        }
        return this.playerOpening.equalsIgnoreCase(playerName);
    }

    public void deleteHologram() {
        if (this.hologram != null) {
            this.hologram.delete();
        }
    }

    public void spawnHologram() {
        this.hologram = HologramsAPI.createHologram((Plugin)CratesPlugin.getPlugin(), (Location)this.loc.clone().add(0.5, 1.0 + this.crate.getHoloDistance(), 0.5));
        for (String line : this.crate.getHologramLines()) {
            if (line.startsWith("$icon:")) {
                String[] split = line.replace("$icon:", "").split(":");
                this.hologram.appendItemLine(new ItemStack(Material.valueOf((String)split[0]), 1, Short.parseShort(split[1])));
                continue;
            }
            if (line.startsWith("$icon-url:")) {
                this.hologram.appendItemLine(SkullURL.getSkull(line.replace("$icon-url:", "")));
                continue;
            }
            this.hologram.appendTextLine(line.replace("&", "\u00a7"));
        }
    }

    public void open(Player player) {
        try {
            CratesPlugin.getPlugin().getAnimationsDao().get(this.crate.getAnimationType()).newInstance().open(player, this);
            this.setPlayerOpening(player.getName().toLowerCase());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public Crate getCrate() {
        return this.crate;
    }

    public Location getLoc() {
        return this.loc;
    }

    public String getPlayerOpening() {
        return this.playerOpening;
    }

    public Hologram getHologram() {
        return this.hologram;
    }

    public void setLoc(Location loc) {
        this.loc = loc;
    }

    public void setPlayerOpening(String playerOpening) {
        this.playerOpening = playerOpening;
    }

    public void setHologram(Hologram hologram) {
        this.hologram = hologram;
    }
}

