/*
 * Decompiled with CFR 0.152.
 */
package hexagonstore.crates.manager;

import hexagonstore.crates.CratesPlugin;
import hexagonstore.crates.dao.CratesSpawnedDao;
import hexagonstore.crates.models.Crate;
import hexagonstore.crates.models.CrateReward;
import hexagonstore.crates.models.CrateSpawned;
import hexagonstore.crates.utils.EC_Config;
import hexagonstore.crates.utils.InventoryUtils;
import hexagonstore.crates.utils.LocationSerializer;
import hexagonstore.crates.utils.language.configuration.MessageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CratesManager {
    private EC_Config config;
    private HashMap<String, BlockFace> directions;
    private CratesSpawnedDao cratesSpawnedDao;
    private MessageUtil messageUtil;

    public CratesManager(EC_Config config, CratesSpawnedDao cratesSpawnedDao, MessageUtil messageUtil) {
        this.config = config;
        this.cratesSpawnedDao = cratesSpawnedDao;
        this.messageUtil = messageUtil;
        this.directions = new HashMap();
    }

    public CrateReward raffle(Crate crate) {
        double porcentagemFinal = 0.0;
        for (CrateReward crateReward : crate.getRewards()) {
            porcentagemFinal += crateReward.getChance();
        }
        double result = new Random().nextDouble() * porcentagemFinal;
        porcentagemFinal = 0.0;
        for (CrateReward crateReward : crate.getRewards()) {
            double porcentagemMin = porcentagemFinal;
            double porcentagemMax = porcentagemFinal += crateReward.getChance();
            if (!(result > porcentagemMin) || !(result < porcentagemMax)) continue;
            return crateReward;
        }
        return crate.getRewards().get(0);
    }

    public void giveTo(CrateReward crateReward, final Player player) {
        crateReward.getCommands().forEach((key, value) -> {
            if (this.chance((double)value)) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)key.replace("@player", player.getName()));
            }
        });
        crateReward.getItems().forEach((key, value) -> {
            if (this.chance((double)value)) {
                if (InventoryUtils.verifyInv(player)) {
                    player.getInventory().addItem(new ItemStack[]{key});
                } else {
                    this.messageUtil.getIdiomConfig().getStringList(this.messageUtil.getLanguage().getMessagePath() + ".dropping_item.message").stream().map(line -> line.replace("&", "\u00a7")).collect(Collectors.toList()).forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
                    new BukkitRunnable((ItemStack)key){
                        int segundos = 3;
                        final /* synthetic */ ItemStack val$key;
                        {
                            this.val$key = itemStack;
                        }

                        public void run() {
                            if (this.segundos <= 1) {
                                if (InventoryUtils.verifyInv(player)) {
                                    player.getInventory().addItem(new ItemStack[]{this.val$key});
                                } else {
                                    player.getWorld().dropItem(player.getLocation(), this.val$key);
                                }
                                player.sendMessage(InventoryUtils.verifyInv(player) ? CratesManager.this.messageUtil.getMessage("dropping_item.canceled") : CratesManager.this.messageUtil.getMessage("dropping_item.dropped"));
                                this.cancel();
                            }
                            player.sendMessage(CratesManager.this.messageUtil.getMessage("dropping_reward.counter").replace("{seconds}", String.valueOf(this.segundos)));
                            --this.segundos;
                        }
                    }.runTaskTimer((Plugin)CratesPlugin.getPlugin(), 0L, 20L);
                }
            }
        });
    }

    public void setDirection(Block block, BlockFace blockFace) {
        switch (blockFace) {
            case WEST: {
                block.setData((byte)5, true);
                break;
            }
            case SOUTH: {
                block.setData((byte)1, true);
                break;
            }
            case NORTH: {
                block.setData((byte)3, true);
                break;
            }
            case EAST: {
                block.setData((byte)4, true);
                break;
            }
        }
    }

    public boolean chance(double percentange) {
        return Math.random() < percentange;
    }

    public void unset(CrateSpawned crateSpawned) {
        String path = "Crates." + crateSpawned.getCrate().getId() + ".locations";
        for (String s : this.config.getStringList(path)) {
            if (!crateSpawned.getLoc().equals((Object)LocationSerializer.getDeserializedLocation(s))) continue;
            ArrayList<String> locations = new ArrayList<String>(this.config.getStringList(path));
            locations.remove(s);
            this.config.set(path, locations);
            this.config.saveConfig();
        }
        this.cratesSpawnedDao.remove(crateSpawned.getLoc());
    }

    public void set(Player player, Crate crate, Location loc, Block block) {
        String path = "Crates." + crate.getId() + ".locations";
        CrateSpawned crateSpawned = new CrateSpawned(crate, loc);
        crateSpawned.spawnHologram();
        this.cratesSpawnedDao.add(crateSpawned.getLoc(), crateSpawned);
        ArrayList<String> newLocationsList = new ArrayList<String>(this.config.getStringList(path));
        newLocationsList.add(LocationSerializer.getSerializedLocation(crateSpawned.getLoc()));
        this.config.set(path, newLocationsList);
        this.config.saveConfig();
        CratesPlugin.getPlugin().getNMSUtils().setDirection(player, block);
    }

    public HashMap<String, BlockFace> getDirections() {
        return this.directions;
    }
}

