/*
 * Decompiled with CFR 0.152.
 */
package hexagonstore.crates.listeners;

import hexagonstore.crates.CratesPlugin;
import hexagonstore.crates.dao.CratesSpawnedDao;
import hexagonstore.crates.manager.CratesManager;
import hexagonstore.crates.models.CrateSpawned;
import hexagonstore.crates.utils.ActionBar;
import hexagonstore.crates.utils.EC_Config;
import hexagonstore.crates.utils.Scroller;
import hexagonstore.crates.utils.language.configuration.MessageUtil;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class InteractEvent
implements Listener {
    private CratesManager manager;
    private CratesSpawnedDao cratesSpawnedDao;
    private MessageUtil messageUtil;
    private EC_Config config;

    public InteractEvent(CratesManager manager, CratesSpawnedDao cratesSpawnedDao, MessageUtil messageUtil, EC_Config config) {
        this.manager = manager;
        this.cratesSpawnedDao = cratesSpawnedDao;
        this.messageUtil = messageUtil;
        this.config = config;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)CratesPlugin.getPlugin());
    }

    @EventHandler
    void evento(PlayerInteractEvent e) {
        Location location;
        Player player = e.getPlayer();
        ItemStack it = player.getItemInHand();
        if (e.getClickedBlock() != null && this.cratesSpawnedDao.contains(location = e.getClickedBlock().getLocation())) {
            CrateSpawned crateSpawned = this.cratesSpawnedDao.get(location);
            switch (e.getAction()) {
                case LEFT_CLICK_BLOCK: {
                    ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                    crateSpawned.getCrate().getRewards().forEach(crateReward -> {
                        if (crateReward.isIconViewMenu()) {
                            items.add(crateReward.getIcon().clone());
                        }
                    });
                    Scroller scroller = Scroller.builder().withName(this.config.getString("Inventory.name").replace("&", "\u00a7")).withSize(this.config.getInt("Inventory.rows") * 9).withAllowedSlots(this.config.getIntegerList("Inventory.allowed-slots")).withNextPageSlot(this.config.getInt("Inventory.next-slot")).withPreviousPageSlot(this.config.getInt("Inventory.back-slot")).withItems(items).build();
                    scroller.open(player);
                    break;
                }
                case RIGHT_CLICK_BLOCK: {
                    e.setCancelled(true);
                    if (crateSpawned.isOpening(player.getName().toLowerCase())) {
                        player.sendMessage(this.messageUtil.getMessage("opening_crate"));
                        return;
                    }
                    if (crateSpawned.hasOpening()) {
                        player.sendMessage(this.messageUtil.getMessage("other_opening_crate"));
                        return;
                    }
                    if (it.isSimilar(crateSpawned.getCrate().getKey())) {
                        if (it.getAmount() > 1) {
                            it.setAmount(it.getAmount() - 1);
                        } else {
                            player.setItemInHand(null);
                        }
                        this.manager.getDirections().put(player.getName().toLowerCase(), e.getBlockFace());
                        crateSpawned.open(player);
                        ActionBar.send(player, this.messageUtil.getMessage("crate_opened_actionbar"));
                        break;
                    }
                    e.setCancelled(true);
                    player.setVelocity(player.getLocation().getDirection().multiply(-1));
                    player.sendMessage(this.messageUtil.getMessage("key_no_supported"));
                }
            }
        }
    }
}

