/*
 * Decompiled with CFR 0.152.
 */
package hexagonstore.crates.dao;

import hexagonstore.crates.models.CrateReward;
import hexagonstore.crates.utils.EC_Config;
import hexagonstore.crates.utils.ItemCreator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class RewardsDao {
    private HashMap<String, CrateReward> rewards = new HashMap();

    public RewardsDao(EC_Config config) {
        this.load(config);
    }

    private void load(EC_Config config) {
        ConfigurationSection section = config.getConfigurationSection("Rewards");
        if (section != null) {
            for (String path : section.getKeys(false)) {
                ConfigurationSection key = section.getConfigurationSection(path);
                ItemStack iconItem = ItemCreator.create(key.getString("icon.skull-url"), key.getString("icon.material"), (short)key.getInt("icon.data"), key.getString("icon.name"), key.getStringList("icon.lore"), key.getBoolean("icon.glow"));
                List hologram = key.getStringList("hologram-lines").stream().map(line -> line.replace("&", "\u00a7")).collect(Collectors.toList());
                List partsList = key.getStringList("commands");
                double holoDistance = key.getDouble("hologram-distance");
                boolean viewIconMenu = key.getBoolean("icon.visible-icon-in-menu");
                double chance = key.getDouble("chance");
                HashMap<String, Double> commands = new HashMap<String, Double>();
                for (String s : partsList) {
                    String[] parts = s.split(";");
                    commands.put(parts[0], Double.parseDouble(parts[1]));
                }
                ConfigurationSection itemsSection = config.getConfigurationSection("Rewards." + path + ".items");
                HashMap<ItemStack, Double> items = new HashMap<ItemStack, Double>();
                itemsSection.getKeys(false).forEach(item -> {
                    ConfigurationSection itemsKey = config.getConfigurationSection("Rewards." + path + ".items." + item);
                    ItemStack rewardItem = ItemCreator.create(itemsKey.getString("skull-url"), itemsKey.getString("material"), (short)itemsKey.getInt("data"), itemsKey.getString("name"), itemsKey.getStringList("lore"), itemsKey.getBoolean("glow"));
                    items.put(rewardItem, itemsKey.getDouble("chance"));
                });
                CrateReward crateReward = new CrateReward(path, iconItem, viewIconMenu, items, commands, new ArrayList<String>(hologram), holoDistance, chance);
                this.add(crateReward.getId().toLowerCase(), crateReward);
                Bukkit.getConsoleSender().sendMessage("\u00a7b[HexagonCrates] \u00a7fReward \u00a7e'" + crateReward.getId() + "' \u00a7fcarregada com \u00eaxito.");
            }
        } else {
            Bukkit.getConsoleSender().sendMessage("\u00a74[HexagonCrates] \u00a7cSection 'rewards' n\u00e3o foi encontrada, contate o desenvolvedor do plugin.");
        }
    }

    public CrateReward get(String s) {
        return this.rewards.get(s.toLowerCase());
    }

    public void add(String s, CrateReward c) {
        this.rewards.put(s.toLowerCase(), c);
    }

    public void remove(String s) {
        this.rewards.remove(s.toLowerCase());
    }

    public boolean contains(String s) {
        return this.rewards.containsKey(s.toLowerCase());
    }

    public HashMap<String, CrateReward> getRewards() {
        return this.rewards;
    }
}

