/*
 * Decompiled with CFR 0.152.
 */
package hexagonstore.crates.dao;

import hexagonstore.crates.dao.CratesDao;
import hexagonstore.crates.models.Crate;
import hexagonstore.crates.models.CrateSpawned;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class CratesSpawnedDao {
    private HashMap<Location, CrateSpawned> cratesSpawned = new HashMap();

    public CratesSpawnedDao(CratesDao cratesDao) {
        this.load(cratesDao);
    }

    private void load(CratesDao cratesDao) {
        for (Crate crate : cratesDao.getCrates().values()) {
            for (Location loc : crate.getLocations()) {
                Block b = loc.getBlock();
                b.setType(crate.getBType());
                CrateSpawned crateSpawned = new CrateSpawned(crate, loc);
                crateSpawned.spawnHologram();
                this.add(loc, crateSpawned);
            }
        }
    }

    public CrateSpawned get(Location l) {
        return this.cratesSpawned.get(l);
    }

    public void add(Location l, CrateSpawned cs) {
        this.cratesSpawned.put(l, cs);
    }

    public void remove(Location loc) {
        this.cratesSpawned.remove(loc);
    }

    public boolean contains(Location l) {
        return this.cratesSpawned.containsKey(l);
    }

    public HashMap<Location, CrateSpawned> getCratesSpawned() {
        return this.cratesSpawned;
    }
}

