/*
 * Decompiled with CFR 0.152.
 */
package hexagonstore.crates.dao;

import hexagonstore.crates.animations.type.AnimationType;
import hexagonstore.crates.dao.RewardsDao;
import hexagonstore.crates.models.Crate;
import hexagonstore.crates.models.CrateReward;
import hexagonstore.crates.utils.EC_Config;
import hexagonstore.crates.utils.ItemCreator;
import hexagonstore.crates.utils.LocationSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class CratesDao {
    private HashMap<String, Crate> crates = new HashMap();

    public CratesDao(EC_Config config, RewardsDao rewardsDao) {
        this.load(config, rewardsDao);
    }

    private void load(EC_Config config, RewardsDao rewardsDao) {
        ConfigurationSection section = config.getConfigurationSection("Crates");
        if (section != null) {
            for (String path : section.getKeys(false)) {
                Object s2;
                ConfigurationSection key = section.getConfigurationSection(path);
                List hologram = key.getStringList("hologram-lines").stream().map(line -> line.replace("&", "\u00a7")).collect(Collectors.toList());
                ArrayList<CrateReward> rewards = new ArrayList<CrateReward>();
                Material bType = Material.valueOf((String)key.getString("blockType"));
                AnimationType animationType = AnimationType.valueOf(key.getString("animationType"));
                double holoDistance = key.getDouble("hologram-distance");
                for (Object s2 : key.getStringList("rewards")) {
                    CrateReward crateReward = rewardsDao.get((String)s2);
                    rewards.add(crateReward);
                }
                ArrayList<Location> locations = new ArrayList<Location>();
                s2 = key.getStringList("locations").iterator();
                while (s2.hasNext()) {
                    String s3 = (String)s2.next();
                    if (s3.isEmpty() || s3.equalsIgnoreCase("nulo") || s3.equalsIgnoreCase("null") || s3.equalsIgnoreCase(" ")) continue;
                    locations.add(LocationSerializer.getDeserializedLocation(s3));
                }
                ItemStack keyItem = ItemCreator.create(key.getString("key.skull-url"), key.getString("key.material"), (short)key.getInt("key.data"), key.getString("key.name"), key.getStringList("key.lore"), key.getBoolean("key.glow"));
                Crate crate = new Crate(path, keyItem, animationType, rewards, new ArrayList<String>(hologram), locations, bType, holoDistance);
                this.add(crate.getId().toLowerCase(), crate);
                Bukkit.getConsoleSender().sendMessage("\u00a7b[HexagonCrates] \u00a7fCrate \u00a7e'" + crate.getId() + "' \u00a7fcarregada com \u00eaxito.");
            }
        } else {
            Bukkit.getConsoleSender().sendMessage("\u00a74[HexagonCrates] \u00a7cSection 'crates' n\u00e3o foi encontrada, contate o desenvolvedor do plugin.");
        }
    }

    public Crate get(String s) {
        return this.crates.get(s.toLowerCase());
    }

    public void add(String s, Crate c) {
        this.crates.put(s.toLowerCase(), c);
    }

    public void remove(String s) {
        this.crates.remove(s.toLowerCase());
    }

    public boolean contains(String s) {
        return this.crates.containsKey(s.toLowerCase());
    }

    public HashMap<String, Crate> getCrates() {
        return this.crates;
    }
}

