/*
 * Decompiled with CFR 0.152.
 */
package hexagonstore.crates.commands;

import hexagonstore.crates.CratesPlugin;
import hexagonstore.crates.dao.CratesSpawnedDao;
import hexagonstore.crates.models.Crate;
import hexagonstore.crates.utils.language.configuration.MessageUtil;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetCrateCommand
implements CommandExecutor {
    private CratesSpawnedDao cratesSpawnedDao;
    private MessageUtil messageUtil;

    public SetCrateCommand(CratesSpawnedDao cratesSpawnedDao, MessageUtil messageUtil) {
        this.cratesSpawnedDao = cratesSpawnedDao;
        this.messageUtil = messageUtil;
        CratesPlugin.getPlugin().getCommand("setcrate").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender s, Command cmd, String lb, String[] a) {
        if (!(s instanceof Player)) {
            s.sendMessage(this.messageUtil.getMessage("no_console"));
            return true;
        }
        Player player = (Player)s;
        if (!s.hasPermission(CratesPlugin.getPlugin().getCfg().getString("CMD Permission.setcrate"))) {
            player.sendMessage(this.messageUtil.getMessage("no_permission"));
            return true;
        }
        if (a.length == 0) {
            player.sendMessage(this.messageUtil.getMessage("no_args.setcrate"));
            return true;
        }
        Crate crate = CratesPlugin.getPlugin().getCratesDao().get(a[0]);
        if (crate == null) {
            player.sendMessage(this.messageUtil.getMessage("crate_not_found"));
            return true;
        }
        int range = 12;
        Block block = player.getTargetBlock((Set)null, range);
        if (block == null) {
            player.sendMessage(this.messageUtil.getMessage("block_no_supported").replace("{range}", String.valueOf(range)));
            return true;
        }
        if (block.getType() == Material.AIR) {
            player.sendMessage(this.messageUtil.getMessage("block_not_found"));
            return true;
        }
        Location loc = block.getLocation();
        if (this.cratesSpawnedDao.contains(loc)) {
            this.cratesSpawnedDao.get(loc).deleteHologram();
            this.cratesSpawnedDao.remove(loc);
            player.sendMessage(this.messageUtil.getMessage("crate_changed"));
        }
        block.setType(crate.getBType());
        CratesPlugin.getPlugin().getManager().set(player, crate, loc, block);
        player.sendMessage(this.messageUtil.getMessage("crate_setted"));
        return false;
    }
}

