/*
 * Decompiled with CFR 0.152.
 */
package hexagonstore.crates.commands;

import hexagonstore.crates.CratesPlugin;
import hexagonstore.crates.models.Crate;
import hexagonstore.crates.utils.EC_Config;
import hexagonstore.crates.utils.InventoryUtils;
import hexagonstore.crates.utils.language.configuration.MessageUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveKeyCommand
implements CommandExecutor {
    private EC_Config config;
    private MessageUtil messageUtil;

    public GiveKeyCommand(EC_Config config, MessageUtil messageUtil) {
        this.config = config;
        this.messageUtil = messageUtil;
        CratesPlugin.getPlugin().getCommand("givekey").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender s, Command cmd, String lb, String[] a) {
        if (!s.hasPermission(this.config.getString("CMD Permission.givekey"))) {
            s.sendMessage(this.messageUtil.getMessage("no_permission"));
            return true;
        }
        if (a.length < 3) {
            s.sendMessage(this.messageUtil.getMessage("no_args.givekey"));
            return true;
        }
        Player target = Bukkit.getPlayer((String)a[0]);
        if (target == null) {
            s.sendMessage(this.messageUtil.getMessage("player_not_found"));
            return true;
        }
        Crate crate = CratesPlugin.getPlugin().getCratesDao().get(a[1]);
        if (crate == null) {
            s.sendMessage(this.messageUtil.getMessage("crate_not_found"));
            return true;
        }
        try {
            int amount = Integer.parseInt(a[2]);
            if (!InventoryUtils.verifyInv(target)) {
                s.sendMessage(this.messageUtil.getMessage("full_inventory"));
                return true;
            }
            ItemStack key = crate.getKey();
            key.setAmount(amount);
            target.getInventory().addItem(new ItemStack[]{key});
            s.sendMessage(this.messageUtil.getMessage("givekey").replace("{player}", target.getName()));
        }
        catch (NumberFormatException ignored) {
            s.sendMessage(this.messageUtil.getMessage("invalid_number"));
        }
        return false;
    }
}

