/*
 * Decompiled with CFR 0.152.
 */
package hexagonstore.crates.animations.utils.spin;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import hexagonstore.crates.CratesPlugin;
import hexagonstore.crates.manager.CratesManager;
import hexagonstore.crates.models.CrateReward;
import hexagonstore.crates.models.CrateSpawned;
import hexagonstore.crates.utils.EC_Config;
import hexagonstore.crates.utils.SkullURL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.v1_8_R3.EnumParticle;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutWorldParticles;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;

public class SpinTask {
    private CrateSpawned crateSpawned;
    private Location initLoc;
    private String playerName;
    private HashMap<ArmorStand, Double> armorStands;
    private CratesManager manager;
    private EC_Config config;
    private Player player;

    public SpinTask(EC_Config config, String playerName, CrateSpawned crateSpawned, Location initLoc) {
        this.config = config;
        this.manager = CratesPlugin.getPlugin().getManager();
        this.armorStands = new HashMap();
        this.playerName = playerName;
        this.crateSpawned = crateSpawned;
        this.initLoc = initLoc;
        this.player = Bukkit.getPlayer((String)playerName);
    }

    public void start() {
        final BlockFace blockFace = this.manager.getDirections().get(this.playerName.toLowerCase());
        final double grausMax = blockFace == BlockFace.NORTH || blockFace == BlockFace.SOUTH ? 450.0 : 366.0;
        final ArrayList<ArmorStand> armorStandsList = new ArrayList<ArmorStand>(this.armorStands.keySet());
        new BukkitRunnable(){
            int index = 0;
            double radius = 1.7;

            public void run() {
                if (this.index == 7) {
                    this.cancel();
                }
                final ArmorStand armorStand = (ArmorStand)armorStandsList.get(this.index);
                new BukkitRunnable(){
                    double graus = 0.0;

                    public void run() {
                        if (this.graus < grausMax) {
                            double cos = Math.cos(Math.toRadians(this.graus));
                            double sin = Math.sin(Math.toRadians(this.graus));
                            Location locToTp = SpinTask.this.initLoc.clone();
                            if (blockFace == BlockFace.NORTH || blockFace == BlockFace.SOUTH) {
                                armorStand.teleport(locToTp.add(cos * radius, sin * radius, 0.0));
                            } else if (blockFace == BlockFace.EAST || blockFace == BlockFace.WEST) {
                                armorStand.teleport(locToTp.add(0.0, cos * radius, sin * radius));
                            }
                            this.graus += 8.0;
                            double g = this.graus;
                            SpinTask.this.armorStands.put(armorStand, g);
                            return;
                        }
                        SpinTask.this.manager.getDirections().remove(SpinTask.this.playerName.toLowerCase());
                        this.cancel();
                    }
                }.runTaskTimer((Plugin)CratesPlugin.getPlugin(), 0L, 1L);
                ++this.index;
            }
        }.runTaskTimerAsynchronously((Plugin)CratesPlugin.getPlugin(), 0L, 8L);
        new BukkitRunnable(){
            ArrayList<ArmorStand> temporaryList = new ArrayList();

            public void run() {
                if (this.temporaryList.size() >= 8) {
                    SpinTask.this.twoStage();
                    this.cancel();
                }
                for (Map.Entry map : SpinTask.this.armorStands.entrySet()) {
                    ArmorStand armorStand = (ArmorStand)map.getKey();
                    double graus = (Double)map.getValue();
                    if (!(graus >= grausMax) || this.temporaryList.contains(armorStand)) continue;
                    this.temporaryList.add(armorStand);
                }
            }
        }.runTaskTimer((Plugin)CratesPlugin.getPlugin(), 0L, 8L);
    }

    private void explosion(Location location) {
        PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(EnumParticle.EXPLOSION_HUGE, true, (float)location.getX(), (float)location.getY(), (float)location.getZ(), 0.0f, 0.0f, 0.0f, 0.0f, 1, new int[0]);
        this.sendPacket(packet);
    }

    private void twoStage() {
        Location loc = null;
        for (ArmorStand armorStand : this.armorStands.keySet()) {
            if (loc == null) {
                loc = armorStand.getLocation();
            }
            armorStand.remove();
        }
        if (loc == null) {
            return;
        }
        this.explosion(loc);
        final ArmorStand armorStand = (ArmorStand)loc.getWorld().spawn(loc, ArmorStand.class);
        armorStand.setGravity(false);
        armorStand.setBasePlate(false);
        armorStand.setHelmet(SkullURL.getSkull(this.config.getString("Animacoes.SPIN.heads.finalHead.skull-url")));
        armorStand.setCustomNameVisible(!this.config.getString("Animacoes.SPIN.heads.finalHead.name").isEmpty());
        armorStand.setCustomName(this.config.getString("Animacoes.SPIN.heads.finalHead.name").replace("&", "\u00a7"));
        armorStand.setVisible(false);
        armorStand.setMetadata("hexagoncrates", (MetadataValue)new FixedMetadataValue((Plugin)CratesPlugin.getPlugin(), new Object(){}));
        new BukkitRunnable(){
            Location loc;
            double yToAdd;
            double y;
            {
                this.loc = armorStand.getLocation().clone();
                this.yToAdd = 0.05;
                this.y = 0.1;
            }

            public void run() {
                if (this.y >= 2.0) {
                    CrateReward crateReward = SpinTask.this.manager.raffle(SpinTask.this.crateSpawned.getCrate());
                    Location loc = SpinTask.this.crateSpawned.getLoc().clone().add(0.5, crateReward.getHoloDistance(), 0.5);
                    SpinTask.this.explosion(loc);
                    SpinTask.this.createExplosion(loc.clone().add(0.0, 1.0, 0.0));
                    armorStand.remove();
                    final Hologram hologram = HologramsAPI.createHologram((Plugin)CratesPlugin.getPlugin(), (Location)loc);
                    for (String line : crateReward.getHologram()) {
                        if (line.startsWith("$icon:")) {
                            String[] split = line.replace("$icon:", "").split(":");
                            hologram.appendItemLine(new ItemStack(Material.valueOf((String)split[0]), 1, Short.parseShort(split[1])));
                            continue;
                        }
                        if (line.startsWith("$icon-url:")) {
                            hologram.appendItemLine(SkullURL.getSkull(line.replace("$icon-url:", "")));
                            continue;
                        }
                        hologram.appendTextLine(line.replace("&", "\u00a7"));
                    }
                    SpinTask.this.manager.giveTo(crateReward, SpinTask.this.player);
                    new BukkitRunnable(){

                        public void run() {
                            CratesPlugin.getPlugin().getNMSUtils().playChestAction(SpinTask.this.crateSpawned.getLoc(), false, SpinTask.this.crateSpawned.getCrate().getBType());
                        }
                    }.runTaskLaterAsynchronously((Plugin)CratesPlugin.getPlugin(), 45L);
                    new BukkitRunnable(){

                        public void run() {
                            SpinTask.this.crateSpawned.setPlayerOpening(null);
                            hologram.delete();
                            SpinTask.this.crateSpawned.spawnHologram();
                        }
                    }.runTaskLater((Plugin)CratesPlugin.getPlugin(), 52L);
                    this.cancel();
                }
                if (this.yToAdd >= 1.0 || this.yToAdd >= 5.0 || this.yToAdd >= 15.0) {
                    this.yToAdd += 0.1;
                }
                armorStand.setHeadPose(new EulerAngle(0.0, armorStand.getHeadPose().getY() + this.yToAdd, 0.0));
                armorStand.teleport(this.loc.subtract(0.0, 0.1, 0.0));
                this.y += 0.1;
            }
        }.runTaskTimer((Plugin)CratesPlugin.getPlugin(), 0L, 1L);
    }

    public void setArmorStands(HashMap<ArmorStand, Double> armorStands) {
        this.armorStands = armorStands;
    }

    private void createExplosion(final Location loc) {
        new BukkitRunnable(){
            double phi = 0.0;
            double radius = 1.5;

            public void run() {
                this.phi += 0.3141592653589793;
                for (double theta = 0.0; theta <= Math.PI * 2; theta += 0.07853981633974483) {
                    double x = this.radius * Math.cos(theta) * Math.sin(this.phi);
                    double y = this.radius * Math.cos(this.phi) * this.radius;
                    double z = this.radius * Math.sin(theta) * Math.sin(this.phi);
                    Location location = loc.clone().add(x, y, z);
                    PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(EnumParticle.SNOWBALL, true, (float)location.getX(), (float)location.getY(), (float)location.getZ(), 0.0f, 0.0f, 0.0f, 0.0f, 1, new int[0]);
                    SpinTask.this.sendPacket(packet);
                }
                if (this.phi > Math.PI) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)CratesPlugin.getPlugin(), 0L, 1L);
    }

    private void sendPacket(PacketPlayOutWorldParticles packet) {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            ((CraftPlayer)onlinePlayer).getHandle().playerConnection.sendPacket((Packet)packet);
        }
    }
}

