/*
 * Decompiled with CFR 0.152.
 */
package hexagonstore.crates.animations;

import hexagonstore.crates.CratesPlugin;
import hexagonstore.crates.animations.base.CreateAnimation;
import hexagonstore.crates.animations.type.AnimationType;
import hexagonstore.crates.animations.utils.spin.SpinTask;
import hexagonstore.crates.models.CrateSpawned;
import hexagonstore.crates.utils.SkullURL;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SpinAnimation
extends CreateAnimation {
    public SpinAnimation() {
        super(AnimationType.SPIN, CratesPlugin.getPlugin().getNMSUtils(), CratesPlugin.getPlugin().getAnimationsConfig(), null);
    }

    @Override
    public void open(final Player player, final CrateSpawned crateSpawned) {
        crateSpawned.deleteHologram();
        if (crateSpawned.getCrate().getBType().equals((Object)Material.CHEST) || crateSpawned.getCrate().getBType().equals((Object)Material.ENDER_CHEST)) {
            this.getNmsUtils().playChestAction(crateSpawned.getLoc(), true, crateSpawned.getCrate().getBType());
        }
        final Location initLoc = crateSpawned.getLoc().clone().add(0.5, -1.2, 0.5);
        initLoc.setYaw(0.0f);
        initLoc.setPitch(0.0f);
        ArmorStand as1 = this.createAs(initLoc, this.getConfig().getString("Animacoes.SPIN.heads.1.name"), this.getConfig().getString("Animacoes.SPIN.heads.1.skull-url"));
        ArmorStand as2 = this.createAs(initLoc, this.getConfig().getString("Animacoes.SPIN.heads.2.name"), this.getConfig().getString("Animacoes.SPIN.heads.2.skull-url"));
        ArmorStand as3 = this.createAs(initLoc, this.getConfig().getString("Animacoes.SPIN.heads.3.name"), this.getConfig().getString("Animacoes.SPIN.heads.3.skull-url"));
        ArmorStand as4 = this.createAs(initLoc, this.getConfig().getString("Animacoes.SPIN.heads.4.name"), this.getConfig().getString("Animacoes.SPIN.heads.4.skull-url"));
        ArmorStand as5 = this.createAs(initLoc, this.getConfig().getString("Animacoes.SPIN.heads.5.name"), this.getConfig().getString("Animacoes.SPIN.heads.5.skull-url"));
        ArmorStand as6 = this.createAs(initLoc, this.getConfig().getString("Animacoes.SPIN.heads.6.name"), this.getConfig().getString("Animacoes.SPIN.heads.6.skull-url"));
        ArmorStand as7 = this.createAs(initLoc, this.getConfig().getString("Animacoes.SPIN.heads.7.name"), this.getConfig().getString("Animacoes.SPIN.heads.7.skull-url"));
        ArmorStand as8 = this.createAs(initLoc, this.getConfig().getString("Animacoes.SPIN.heads.8.name"), this.getConfig().getString("Animacoes.SPIN.heads.8.skull-url"));
        final HashMap<ArmorStand, Double> armorStands = new HashMap<ArmorStand, Double>();
        armorStands.put(as1, 0.0);
        armorStands.put(as5, 0.0);
        armorStands.put(as8, 0.0);
        armorStands.put(as7, 0.0);
        armorStands.put(as4, 0.0);
        armorStands.put(as6, 0.0);
        armorStands.put(as3, 0.0);
        armorStands.put(as2, 0.0);
        new BukkitRunnable(){
            Location locUp;
            int t;
            {
                this.locUp = initLoc.clone();
                this.t = 0;
            }

            public void run() {
                if (this.t >= 8) {
                    this.cancel();
                    SpinTask spinTask = new SpinTask(SpinAnimation.this.getConfig(), player.getName(), crateSpawned, this.locUp);
                    spinTask.setArmorStands(armorStands);
                    spinTask.start();
                }
                for (ArmorStand armorStand : armorStands.keySet()) {
                    armorStand.teleport(this.locUp.add(0.0, 0.01, 0.0));
                }
                ++this.t;
            }
        }.runTaskTimer((Plugin)CratesPlugin.getPlugin(), 0L, 1L);
    }

    private ArmorStand createAs(Location loc, String name, String skullURL) {
        ArmorStand as = (ArmorStand)loc.getWorld().spawn(loc, ArmorStand.class);
        as.setGravity(false);
        as.setBasePlate(false);
        as.setHelmet(SkullURL.getSkull(skullURL));
        as.setCustomNameVisible(!name.isEmpty());
        as.setCustomName(name.replace("&", "\u00a7"));
        as.setVisible(false);
        as.setMetadata("hexagoncrates", (MetadataValue)new FixedMetadataValue((Plugin)CratesPlugin.getPlugin(), new Object(){}));
        return as;
    }
}

