/*
 * Decompiled with CFR 0.152.
 */
package hexagonstore.crates.animations;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import hexagonstore.crates.CratesPlugin;
import hexagonstore.crates.animations.base.CreateAnimation;
import hexagonstore.crates.animations.type.AnimationType;
import hexagonstore.crates.models.CrateReward;
import hexagonstore.crates.models.CrateSpawned;
import hexagonstore.crates.utils.SkullURL;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ExplosionAnimation
extends CreateAnimation {
    public ExplosionAnimation() {
        super(AnimationType.EXPLOSION, CratesPlugin.getPlugin().getNMSUtils(), CratesPlugin.getPlugin().getCfg(), CratesPlugin.getPlugin().getManager());
    }

    @Override
    public void open(Player player, final CrateSpawned crateSpawned) {
        this.getNmsUtils().playChestAction(crateSpawned.getLoc(), true, crateSpawned.getCrate().getBType());
        crateSpawned.deleteHologram();
        CrateReward crateReward = this.getManager().raffle(crateSpawned.getCrate());
        Location loc = crateSpawned.getLoc().clone().add(0.5, crateReward.getHoloDistance(), 0.5);
        loc.getWorld().createExplosion(loc.getX() + 0.4, loc.getY() + 1.35, loc.getZ(), 0.0f, false, false);
        final Hologram hologram = HologramsAPI.createHologram((Plugin)CratesPlugin.getPlugin(), (Location)loc);
        for (String line : crateReward.getHologram()) {
            if (line.startsWith("$icon:")) {
                String[] split = line.replace("$icon:", "").split(":");
                hologram.appendItemLine(new ItemStack(Material.valueOf((String)split[0]), 1, Short.parseShort(split[1])));
                continue;
            }
            if (line.startsWith("$icon-url:")) {
                hologram.appendItemLine(SkullURL.getSkull(line.replace("$icon-url:", "")));
                continue;
            }
            hologram.appendTextLine(line.replace("&", "\u00a7"));
        }
        this.getManager().giveTo(crateReward, player);
        this.explodeFirework(loc);
        new BukkitRunnable(){

            public void run() {
                hologram.delete();
                ExplosionAnimation.this.getNmsUtils().playChestAction(crateSpawned.getLoc(), false, crateSpawned.getCrate().getBType());
                crateSpawned.setPlayerOpening(null);
                crateSpawned.spawnHologram();
            }
        }.runTaskLater((Plugin)CratesPlugin.getPlugin(), 30L);
    }

    private void explodeFirework(Location loc) {
        final Firework firework = (Firework)loc.getWorld().spawn(loc, Firework.class);
        FireworkMeta data = firework.getFireworkMeta();
        data.addEffects(new FireworkEffect[]{FireworkEffect.builder().withColor(Color.PURPLE).withColor(Color.GREEN).with(FireworkEffect.Type.BALL_LARGE).withFlicker().build()});
        data.setPower(1);
        firework.setFireworkMeta(data);
        new BukkitRunnable(){

            public void run() {
                firework.detonate();
            }
        }.runTaskLater((Plugin)CratesPlugin.getPlugin(), 2L);
    }
}

