/*
 * Decompiled with CFR 0.152.
 */
package hexagonstore.crates;

import hexagonstore.crates.commands.GiveKeyCommand;
import hexagonstore.crates.commands.SetCrateCommand;
import hexagonstore.crates.dao.AnimationsDao;
import hexagonstore.crates.dao.CratesDao;
import hexagonstore.crates.dao.CratesSpawnedDao;
import hexagonstore.crates.dao.RewardsDao;
import hexagonstore.crates.listeners.BreakEvent;
import hexagonstore.crates.listeners.InteractEvent;
import hexagonstore.crates.listeners.PlaceEvent;
import hexagonstore.crates.manager.CratesManager;
import hexagonstore.crates.utils.EC_Config;
import hexagonstore.crates.utils.NMSUtilsBase;
import hexagonstore.crates.utils.language.Language;
import hexagonstore.crates.utils.language.configuration.MessageUtil;
import hexagonstore.crates.utils.language.impl.EnglishLanguage;
import hexagonstore.crates.utils.language.impl.PortugueseLanguage;
import hexagonstore.crates.utils.language.type.LanguageType;
import hexagonstore.crates.utils.nms.NMSUtils_1_10_R2;
import hexagonstore.crates.utils.nms.NMSUtils_1_11_R1;
import hexagonstore.crates.utils.nms.NMSUtils_1_12_R1;
import hexagonstore.crates.utils.nms.NMSUtils_1_13_R1;
import hexagonstore.crates.utils.nms.NMSUtils_1_14_R1;
import hexagonstore.crates.utils.nms.NMSUtils_1_15_R1;
import hexagonstore.crates.utils.nms.NMSUtils_1_16_R3;
import hexagonstore.crates.utils.nms.NMSUtils_1_8_R3;
import hexagonstore.crates.utils.nms.NMSUtils_1_9_R2;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CratesPlugin
extends JavaPlugin {
    private static CratesPlugin instance;
    private NMSUtilsBase nmsUtils;
    private MessageUtil messageUtil;
    private Language language;
    private EC_Config config;
    private EC_Config animationsConfig;
    private CratesManager manager;
    private String version;
    private CratesDao cratesDao;
    private CratesSpawnedDao cratesSpawnedDao;
    private AnimationsDao animationsDao;
    private RewardsDao rewardsDao;

    public static CratesPlugin getPlugin() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        if (this.loadMultipleNMSSuport()) {
            this.config = new EC_Config(this, null, "config.yml", false);
            this.animationsConfig = new EC_Config(this, null, "animations.yml", false);
            switch (LanguageType.valueOf(this.config.getString("Language").toUpperCase())) {
                case PT_BR: {
                    this.language = new PortugueseLanguage();
                    break;
                }
                case EN_US: {
                    this.language = new EnglishLanguage();
                    break;
                }
                default: {
                    Bukkit.getConsoleSender().sendMessage("\u00a74[HexagonCrates] \u00a7cLinguagem inserida na 'config.yml' \u00e9 inv\u00e1lida.");
                    Bukkit.getConsoleSender().sendMessage("\u00a74[HexagonCrates] \u00a7cThe language in 'config.yml' is not valid!");
                    Bukkit.getPluginManager().disablePlugin((Plugin)this);
                }
            }
            this.messageUtil = new MessageUtil();
            this.messageUtil.load(this);
            this.language.load(this.messageUtil, this);
            this.messageUtil.setLanguage(this.language);
            this.rewardsDao = new RewardsDao(this.config);
            this.animationsDao = new AnimationsDao();
            this.cratesDao = new CratesDao(this.config, this.rewardsDao);
            this.cratesSpawnedDao = new CratesSpawnedDao(this.cratesDao);
            this.manager = new CratesManager(this.config, this.cratesSpawnedDao, this.messageUtil);
            new SetCrateCommand(this.cratesSpawnedDao, this.messageUtil);
            new GiveKeyCommand(this.config, this.messageUtil);
            new BreakEvent(this.cratesSpawnedDao);
            new InteractEvent(this.manager, this.cratesSpawnedDao, this.messageUtil, this.config);
            new PlaceEvent();
            Bukkit.getConsoleSender().sendMessage("\u00a72[HexagonCrates] \u00a7aPlugin habilitado com \u00eaxito.");
        } else {
            Bukkit.getConsoleSender().sendMessage("\u00a7cA vers\u00e3o no qual o servidor utiliza n\u00e3o \u00e9 suportada pelo plugin.");
            Bukkit.getConsoleSender().sendMessage("\u00a7cVers\u00f5es dispon\u00edveis: 1.8 at\u00e9 1.16.5!");
        }
    }

    public void onDisable() {
        Bukkit.getConsoleSender().sendMessage("\u00a74[HexagonCrates] \u00a7cPlugin desabilitado com \u00eaxito.");
    }

    public boolean loadMultipleNMSSuport() {
        try {
            this.version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        }
        catch (ArrayIndexOutOfBoundsException whatVersionAreYouUsingException) {
            return false;
        }
        Bukkit.getConsoleSender().sendMessage("\u00a76[HexagonCrates] \u00a7eEste servidor est\u00e1 rodando na vers\u00e3o: \u00a7f" + this.version + ".");
        switch (this.version) {
            case "v1_8_R3": {
                this.nmsUtils = new NMSUtils_1_8_R3();
                break;
            }
            case "v1_9_R2": {
                this.nmsUtils = new NMSUtils_1_9_R2();
                break;
            }
            case "v1_10_R2": {
                this.nmsUtils = new NMSUtils_1_10_R2();
                break;
            }
            case "v1_11_R1": {
                this.nmsUtils = new NMSUtils_1_11_R1();
                break;
            }
            case "v1_12_R1": {
                this.nmsUtils = new NMSUtils_1_12_R1();
                break;
            }
            case "v1_13_R1": {
                this.nmsUtils = new NMSUtils_1_13_R1();
                break;
            }
            case "v1_14_R1": {
                this.nmsUtils = new NMSUtils_1_14_R1();
                break;
            }
            case "v1_15_R1": {
                this.nmsUtils = new NMSUtils_1_15_R1();
                break;
            }
            case "v1_16_R3": {
                this.nmsUtils = new NMSUtils_1_16_R3();
                break;
            }
        }
        return this.nmsUtils != null;
    }

    public MessageUtil getMessageUtil() {
        return this.messageUtil;
    }

    public EC_Config getAnimationsConfig() {
        return this.animationsConfig;
    }

    public CratesDao getCratesDao() {
        return this.cratesDao;
    }

    public CratesSpawnedDao getCratesSpawnedDao() {
        return this.cratesSpawnedDao;
    }

    public AnimationsDao getAnimationsDao() {
        return this.animationsDao;
    }

    public RewardsDao getRewardsDao() {
        return this.rewardsDao;
    }

    public CratesManager getManager() {
        return this.manager;
    }

    public String getVersion() {
        return this.version;
    }

    public NMSUtilsBase getNMSUtils() {
        return this.nmsUtils;
    }

    public EC_Config getCfg() {
        return this.config;
    }
}

