/*
 * Decompiled with CFR 0.152.
 */
package jordan.sicherman.headhunter;

import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    private static final Random random = new Random();

    public void onEnable() {
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @EventHandler
    private void onKill(EntityDeathEvent e) {
        if (e.getEntity().getKiller() != null) {
            if (!e.getEntity().getKiller().hasPermission("Headhunter.obtain")) {
                return;
            }
            ItemStack hand = e.getEntity().getKiller().getItemInHand();
            if (hand != null && hand.hasItemMeta() && hand.getItemMeta().hasEnchant(Enchantment.LOOT_BONUS_MOBS) && random.nextDouble() <= this.getConfig().getDouble("probability") * (double)hand.getItemMeta().getEnchantLevel(Enchantment.LOOT_BONUS_MOBS)) {
                e.getDrops().add(this.headFor((Entity)e.getEntity()));
            }
        }
    }

    private ItemStack headFor(Entity entity) {
        EntityType type = entity.getType();
        SkullType skull = null;
        String slug = "";
        String friendly = null;
        switch (type) {
            case BLAZE: {
                slug = "Blaze";
                break;
            }
            case CAVE_SPIDER: {
                slug = "CaveSpider";
                friendly = "Cave Spider";
                break;
            }
            case CHICKEN: {
                slug = "Chicken";
                break;
            }
            case COW: {
                slug = "Cow";
                break;
            }
            case CREEPER: {
                skull = SkullType.CREEPER;
                break;
            }
            case ENDERMAN: {
                slug = "Enderman";
                break;
            }
            case GHAST: {
                slug = "Ghast";
                break;
            }
            case IRON_GOLEM: {
                slug = "Golem";
                friendly = "Iron Golem";
                break;
            }
            case MAGMA_CUBE: {
                slug = "LavaSlime";
                friendly = "Magma Cube";
                break;
            }
            case MUSHROOM_COW: {
                slug = "MushroomCow";
                friendly = "Mooshroom";
                break;
            }
            case OCELOT: {
                slug = "Ocelot";
                break;
            }
            case PIG: {
                slug = "Pig";
                break;
            }
            case PIG_ZOMBIE: {
                slug = "PigZombie";
                friendly = "Zombie Pigman";
                break;
            }
            case PLAYER: {
                slug = ((Player)entity).getName();
                break;
            }
            case SHEEP: {
                slug = "Sheep";
                break;
            }
            case SKELETON: {
                if (((Skeleton)entity).getSkeletonType() == Skeleton.SkeletonType.WITHER) {
                    skull = SkullType.WITHER;
                    break;
                }
                skull = SkullType.SKELETON;
                break;
            }
            case SLIME: {
                slug = "Slime";
                break;
            }
            case SPIDER: {
                slug = "Spider";
                break;
            }
            case SQUID: {
                slug = "Squid";
                break;
            }
            case VILLAGER: {
                slug = "Villager";
                break;
            }
            case ZOMBIE: 
            case GIANT: {
                skull = SkullType.ZOMBIE;
                break;
            }
            default: {
                slug = "Present" + random.nextInt(2) + 1;
                friendly = "Giftbox";
            }
        }
        ItemStack head = new ItemStack(Material.SKULL_ITEM, 1, this.skull(skull));
        if (skull == null) {
            SkullMeta meta = (SkullMeta)head.getItemMeta();
            meta.setOwner((type == EntityType.PLAYER ? "" : "MHF_") + slug);
            if (friendly == null) {
                friendly = slug;
            }
            meta.setDisplayName(ChatColor.RESET + friendly + (friendly.equals("Giftbox") ? "" : " Head"));
            head.setItemMeta((ItemMeta)meta);
        }
        return head;
    }

    private short skull(SkullType type) {
        if (type == null) {
            return 3;
        }
        switch (type) {
            case CREEPER: {
                return 4;
            }
            case SKELETON: {
                return 0;
            }
            case WITHER: {
                return 1;
            }
            case ZOMBIE: {
                return 2;
            }
        }
        return 3;
    }
}

