/*
 * Decompiled with CFR 0.152.
 */
package net.devscape.project.guilds.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.devscape.project.guilds.Guilds;
import net.devscape.project.guilds.handlers.Guild;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class Message {
    public static void send(Guilds plugin, CommandSender sender, String messagePath) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(plugin.getConfig().getString("messages." + messagePath))));
    }

    public static void sendPlaceholder(Guilds plugin, CommandSender sender, String messagePath, String placeholder) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(plugin.getConfig().getString("messages." + messagePath)).replace("%placeholder%", placeholder)));
    }

    public static void sendPlaceholders(Guilds plugin, CommandSender sender, String messagePath, Map<String, String> placeholders) {
        String output = plugin.getConfig().getString("messages." + messagePath);
        for (String placeholder : placeholders.keySet()) {
            output = Objects.requireNonNull(output).replace(placeholder, placeholders.get(placeholder));
        }
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(output)));
    }

    public static void sendPlaceholderPath(Guilds plugin, CommandSender sender, String messagePath, String placeholder) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(plugin.getConfig().getString(messagePath)).replace("%placeholder%", placeholder)));
    }

    public static void sendPlaceholder(Guilds plugin, Player sender, String messagePath, String placeholder) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(plugin.getConfig().getString("messages." + messagePath)).replace("%placeholder%", placeholder)));
    }

    public static void sendHelp(Guilds plugin, CommandSender sender, String messagePath, String placeholder) {
        ConfigurationSection section = plugin.getConfig().getConfigurationSection(messagePath);
        for (String key : Objects.requireNonNull(section).getKeys(false)) {
            if (key.equals("header")) {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(plugin.getConfig().getString(messagePath + "." + key))));
                continue;
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(plugin.getConfig().getString(messagePath + "." + key)).replace("%placeholder%", placeholder)));
        }
    }

    public static void sendGuildList(Guilds plugin, CommandSender sender, String messagePath, String[] placeholder) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(plugin.getConfig().getString("messages." + messagePath)).replace("%number%", placeholder[0]).replace("%guildName%", placeholder[1]).replace("%members%", placeholder[2])));
    }

    public static void sendGuildInfo(Guilds plugin, CommandSender sender, String messagePath, Guild guild) {
        ConfigurationSection section = plugin.getConfig().getConfigurationSection(messagePath);
        Iterator iterator = Objects.requireNonNull(section).getKeys(false).iterator();
        block20: while (iterator.hasNext()) {
            String s;
            String key = s = (String)iterator.next();
            switch (s) {
                case "header": {
                    Message.sendPlaceholderPath(plugin, sender, messagePath + "." + key, guild.getName());
                    continue block20;
                }
                case "leader": {
                    Message.sendPlaceholderPath(plugin, sender, messagePath + "." + key, Bukkit.getOfflinePlayer((UUID)guild.getOwner()).getName());
                    continue block20;
                }
                case "description": {
                    Message.sendPlaceholderPath(plugin, sender, messagePath + "." + key, guild.getDescription());
                    continue block20;
                }
                case "level": {
                    Message.sendPlaceholderPath(plugin, sender, messagePath + "." + key, guild.getLevel() + "/" + guild.getMaxLevel());
                    continue block20;
                }
                case "size": {
                    Message.sendPlaceholderPath(plugin, sender, messagePath + "." + key, guild.getMembers().size() + "/" + guild.getMaxMembers());
                    continue block20;
                }
                case "online": {
                    int online = 0;
                    for (UUID member : guild.getMembers().keySet()) {
                        if (Bukkit.getPlayer((UUID)member) == null) continue;
                        ++online;
                    }
                    Message.sendPlaceholderPath(plugin, sender, messagePath + "." + key, online + "/" + guild.getMembers().size());
                    continue block20;
                }
                case "members": {
                    StringBuilder string = new StringBuilder();
                    string.append(plugin.getConfig().getString(messagePath + "." + key)).append(" ");
                    for (UUID member2 : guild.getMembers().keySet()) {
                        string.append(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(section.getString("member-color")))).append(Bukkit.getOfflinePlayer((UUID)member2).getName()).append(" ");
                    }
                    Message.sendRaw(sender, string.toString());
                    continue block20;
                }
                case "bottom": {
                    Message.send(plugin, sender, "guild-info." + key);
                    continue block20;
                }
            }
        }
    }

    public static void sendRaw(CommandSender sender, String message) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    public static void sendMessage(Player p, String msg) {
        p.sendMessage(Message.format(msg));
    }

    public static String deformat(String str) {
        return ChatColor.stripColor((String)Message.format(str));
    }

    public static List<String> format(List<String> lore) {
        return lore.stream().map(Message::format).collect(Collectors.toList());
    }

    public static String format(String message) {
        message = message.replace(">>", "").replace("<<", "");
        Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]){6}");
        Matcher matcher = hexPattern.matcher(message);
        while (matcher.find()) {
            net.md_5.bungee.api.ChatColor hexColor = net.md_5.bungee.api.ChatColor.of((String)matcher.group().substring(1));
            String before = message.substring(0, matcher.start());
            String after = message.substring(matcher.end());
            message = before + hexColor + after;
            matcher = hexPattern.matcher(message);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

