/*
 * Decompiled with CFR 0.152.
 */
package net.devscape.project.guilds.storage.file;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.devscape.project.guilds.Guilds;
import net.devscape.project.guilds.handlers.GPlayer;
import net.devscape.project.guilds.handlers.Guild;
import net.devscape.project.guilds.handlers.Role;
import net.devscape.project.guilds.handlers.Warp;
import net.devscape.project.guilds.storage.ManageData;
import net.devscape.project.guilds.storage.file.FileCache;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class FileManager
implements ManageData {
    private final Guilds plugin;
    private final FileCache cache;

    public FileManager(Guilds plugin) {
        this.plugin = plugin;
        this.cache = new FileCache();
    }

    public FileCache getCache() {
        return this.cache;
    }

    @Override
    public Optional<Guild> getGuild(String name) {
        return this.getCache().getGuild(name);
    }

    @Override
    public Optional<Guild> getGuild(UUID playerUuid) {
        if (!this.getCache().getPlayer(playerUuid).isPresent()) {
            return Optional.empty();
        }
        String guildId = this.getCache().getPlayer(playerUuid).get().getGuildId();
        return this.getCache().getGuild(guildId);
    }

    @Override
    public Optional<GPlayer> getPlayer(UUID id) {
        return this.getCache().getPlayer(id);
    }

    @Override
    public Optional<Warp> getWarp(UUID id, String warpId) {
        if (!this.getCache().getPlayer(id).isPresent()) {
            return Optional.empty();
        }
        String guildId = this.getCache().getPlayer(id).get().getGuildId();
        if (guildId == null) {
            return Optional.empty();
        }
        if (!this.getCache().getPlayer(id).isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.getCache().getGuild(guildId).get().getWarps().get(warpId));
    }

    @Override
    public boolean hasInvite(UUID uuid, String guildId) {
        return this.getCache().getPlayer(uuid).isPresent() && this.getCache().getPlayer(uuid).get().hasInvite(guildId);
    }

    @Override
    public List<Guild> getAllGuilds() {
        ArrayList<Guild> guildList = new ArrayList<Guild>();
        Map<String, Guild> guilds = this.getCache().getGuilds();
        for (String id : guilds.keySet()) {
            guildList.add(guilds.get(id));
        }
        return guildList;
    }

    @Override
    public boolean saveAllData() {
        try {
            this.saveAllGuilds();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public boolean loadAllData() {
        this.loadAllGuilds();
        return true;
    }

    @Override
    public boolean saveGuild(Guild guild) {
        if (this.getCache().getGuilds().containsKey(guild.getName())) {
            this.getCache().getGuilds().replace(guild.getName(), guild);
        } else {
            this.getCache().addGuild(guild);
        }
        return true;
    }

    @Override
    public boolean savePlayer(GPlayer player) {
        if (this.getCache().playerExists(player.getUuid())) {
            this.getCache().getPlayers().replace(player.getUuid(), new GPlayer(player.getUuid(), player.getGuildId(), player.getRole()));
        } else {
            this.getCache().addPlayer(player.getUuid(), player.getGuildId(), player.getRole());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAllGuilds() throws IOException {
        OutputStreamWriter file = null;
        Set<String> guildIds = this.getCache().getGuilds().keySet();
        ArrayList<Guild> guildList = new ArrayList<Guild>();
        for (String string : guildIds) {
            if (!this.getCache().getGuild(string).isPresent()) continue;
            guildList.add(this.getCache().getGuild(string).get());
        }
        JSONArray guildsArray = new JSONArray();
        for (Guild guild2 : guildList) {
            JSONObject guildJson = new JSONObject();
            guildJson.put((Object)"guild", (Object)guild2);
            guildsArray.add((Object)guildJson);
        }
        try {
            file = new FileWriter(this.plugin.getDataFolder().getAbsolutePath() + "//guilds.json");
            file.write(guildsArray.toJSONString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            ((FileWriter)Objects.requireNonNull(file)).flush();
            file.close();
        }
        finally {
            try {
                ((FileWriter)Objects.requireNonNull(file)).flush();
                file.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void loadAllGuilds() {
        try {
            FileReader reader = new FileReader(this.plugin.getDataFolder().getAbsolutePath() + "//guilds.json");
            Object object = new JSONParser().parse((Reader)reader);
            ((JSONArray)object).forEach(guild -> this._addGuild((JSONObject)guild));
        }
        catch (IOException | ParseException ex2) {
            Throwable ex;
            Throwable e = ex = null;
            e.printStackTrace();
        }
    }

    private void _addGuild(JSONObject guilds) {
        JSONObject guild = (JSONObject)guilds.getOrDefault((Object)"guild", null);
        String name = String.valueOf(guild.getOrDefault((Object)"name", null));
        String ownerId = String.valueOf(guild.getOrDefault((Object)"owner", null));
        String description = String.valueOf(guild.getOrDefault((Object)"description", (Object)"No description set!"));
        ArrayList members = (ArrayList)guild.getOrDefault((Object)"members", new ArrayList());
        ArrayList warps = (ArrayList)guild.getOrDefault((Object)"warps", new ArrayList());
        long level = (Long)guild.getOrDefault((Object)"level", (Object)1);
        Guild guildObject = new Guild(name, UUID.fromString(ownerId), description, members, warps, (int)level);
        this._addMembers(members, name);
        this.getCache().addGuild(guildObject);
    }

    private void _addMembers(ArrayList<Object> memberObjects, String name) {
        memberObjects.forEach(member -> this._addMember((JSONObject)member, name));
    }

    private void _addMember(JSONObject member, String name) {
        String id = String.valueOf(member.get((Object)"player"));
        String role = String.valueOf(member.get((Object)"role"));
        this.getCache().addPlayer(UUID.fromString(id), name, Role.valueOf(role));
    }

    @Override
    public boolean deleteGuild(String guildName) {
        this.getCache().removeGuild(guildName);
        return true;
    }

    @Override
    public boolean saveInvite(UUID receiver, String guildName) {
        if (!this.getCache().getPlayer(receiver).isPresent()) {
            return false;
        }
        this.getCache().getPlayer(receiver).get().addInvite(guildName);
        return true;
    }

    @Override
    public boolean saveWarp(String id, String world, double x, double y, double z, float yaw, float pitch, String guildId) {
        Optional<Guild> guild = this.getCache().getGuild(guildId);
        if (!guild.isPresent()) {
            return false;
        }
        if (guild.get().getWarps().containsKey(id)) {
            guild.get().getWarps().replace(id, new Warp(id, world, x, y, z, yaw, pitch));
        } else {
            guild.get().getWarps().put(id, new Warp(id, world, x, y, z, yaw, pitch));
        }
        return true;
    }

    @Override
    public boolean deletePlayer(String id) {
        this.getCache().removePlayer(UUID.fromString(id));
        return true;
    }

    @Override
    public boolean deleteInvite(UUID receiver, String name) {
        if (!this.getCache().getPlayer(receiver).isPresent()) {
            return false;
        }
        this.getCache().getPlayer(receiver).get().removeInvite(name);
        return true;
    }

    @Override
    public boolean deleteWarp(String guildId, String warpId) {
        if (!this.getCache().getGuild(guildId).isPresent()) {
            return false;
        }
        this.getCache().getGuild(guildId).get().removeWarp(warpId);
        return true;
    }
}

