/*
 * Decompiled with CFR 0.152.
 */
package net.devscape.project.guilds.menus.pages;

import java.util.UUID;
import net.devscape.project.guilds.Guilds;
import net.devscape.project.guilds.menus.Menu;
import net.devscape.project.guilds.menus.MenuUtil;
import net.devscape.project.guilds.util.Message;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MembersMenu
extends Menu {
    public MembersMenu(MenuUtil menuUtil) {
        super(menuUtil);
    }

    @Override
    public String getMenuName() {
        return "Guild > Members";
    }

    @Override
    public int getSlots() {
        return 45;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player player = (Player)e.getWhoClicked();
        e.setCancelled(true);
        if (e.getCurrentItem().hasItemMeta() && e.getCurrentItem().getType().equals((Object)Material.PLAYER_HEAD)) {
            String member = Message.deformat(e.getCurrentItem().getItemMeta().getDisplayName());
            OfflinePlayer m = Bukkit.getOfflinePlayer((String)member);
            OfflinePlayer o = Bukkit.getOfflinePlayer((UUID)this.menuUtil.getGuild().getOwner());
            if (this.menuUtil.getGuild().getMembers().containsKey(m.getUniqueId())) {
                if (!m.getUniqueId().equals(o.getUniqueId())) {
                    this.menuUtil.getGuild().removeMember(m.getUniqueId());
                    Guilds.getInstance().getData().saveGuild(this.menuUtil.getGuild());
                    player.closeInventory();
                    new MembersMenu(Guilds.getMenuUtil((Player)e.getWhoClicked(), this.menuUtil.getGuild())).open();
                    player.sendMessage(Message.format("&aThis player has been removed."));
                } else {
                    player.sendMessage(Message.format("&cThe owner of a guild cannot be removed."));
                }
            }
        }
    }

    @Override
    public void setMenuItems() {
        for (UUID uuid : this.menuUtil.getGuild().getMembers().keySet()) {
            OfflinePlayer member = Bukkit.getOfflinePlayer((UUID)uuid);
            OfflinePlayer m = Bukkit.getOfflinePlayer((UUID)uuid);
            OfflinePlayer o = Bukkit.getOfflinePlayer((UUID)this.menuUtil.getGuild().getOwner());
            if (!m.getUniqueId().equals(o.getUniqueId())) {
                this.inventory.addItem(new ItemStack[]{this.makeItem(Material.PLAYER_HEAD, Message.format("&a" + member.getName()), Message.format("&7Right Click to Remove!"))});
            }
            if (!this.inventory.isEmpty()) continue;
            this.inventory.setItem(22, this.makeItem(Material.HOPPER, Message.format("&cYou have no members yet!"), new String[0]));
        }
    }
}

