/*
 * Decompiled with CFR 0.152.
 */
package net.devscape.project.guilds.commands;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.devscape.project.guilds.Guilds;
import net.devscape.project.guilds.SubCommand;
import net.devscape.project.guilds.handlers.Guild;
import net.devscape.project.guilds.util.Message;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Upgrade
extends SubCommand {
    private final String label;

    public Upgrade(Guilds plugin, CommandSender sender, String[] args, String label) {
        super(plugin, sender, args);
        this.label = label;
        this.execute();
    }

    private void execute() {
        if (this.getSender() instanceof Player) {
            Player player = (Player)this.getSender();
            Optional<Guild> guild = this.getPlugin().getData().getGuild(player.getUniqueId());
            if (!guild.isPresent()) {
                Message.send(this.getPlugin(), this.getSender(), "not-in-guild");
                return;
            }
            int level = guild.get().getLevel();
            int upgradeCost = this.getPlugin().getConfig().getInt("settings.upgrade-costs.level-" + level);
            if (this.getPlugin().getConfig().getBoolean("settings.enable-guild-upgrades")) {
                if (!guild.get().isOwner(player.getUniqueId())) {
                    Message.send(this.getPlugin(), this.getSender(), "must-be-owner");
                } else if (guild.get().getLevel() == guild.get().getMaxLevel()) {
                    Message.send(this.getPlugin(), this.getSender(), "already-max-level");
                } else if (Guilds.getEcon().has(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()), (double)upgradeCost)) {
                    Guilds.getEcon().withdrawPlayer(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()), (double)upgradeCost);
                    guild.get().setLevel(guild.get().getLevel() + 1);
                    this.getPlugin().getData().saveGuild(guild.get());
                    String message = ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(this.getPlugin().getConfig().getString("messages.guild-level-up"))).replace("%placeholder%", String.valueOf(guild.get().getLevel()));
                    player.sendMessage(message);
                }
            } else {
                Message.sendMessage(player, "&cUpgrades feature is disabled.");
            }
        } else {
            Message.send(this.getPlugin(), this.getSender(), "not-console-command");
        }
    }
}

