/*
 * Decompiled with CFR 0.152.
 */
package net.devscape.project.guilds.commands;

import java.util.Optional;
import net.devscape.project.guilds.Guilds;
import net.devscape.project.guilds.SubCommand;
import net.devscape.project.guilds.handlers.Warp;
import net.devscape.project.guilds.util.Message;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GoToWarp
extends SubCommand {
    public GoToWarp(Guilds plugin, CommandSender sender, String[] args) {
        super(plugin, sender, args);
        this.execute();
    }

    private void execute() {
        Player player = (Player)this.getSender();
        String warpName = this.getArgs()[1];
        Optional<Warp> warp = this.getPlugin().getData().getWarp(player.getUniqueId(), warpName);
        if (warp.isPresent()) {
            this.teleportWarmup(player, warp.get());
        } else {
            Message.sendPlaceholder(this.getPlugin(), this.getSender(), "warp-error", warpName);
        }
    }

    private void teleportWarmup(final Player player, final Warp warp) {
        final Location loc = player.getLocation();
        new BukkitRunnable(){
            int secondsLeft = 5;

            public void run() {
                if (loc.getX() != player.getLocation().getX() || loc.getZ() != player.getLocation().getZ()) {
                    player.sendMessage("\u00a7cTeleportation cancelled due to movement!");
                    this.cancel();
                    return;
                }
                if (this.secondsLeft == 0) {
                    player.teleport(warp.toLocation());
                    Message.sendPlaceholder(GoToWarp.this.getPlugin(), GoToWarp.this.getSender(), "warp", warp.getId());
                    this.cancel();
                    return;
                }
                player.sendMessage("\u00a77Teleporting in \u00a72\u00a7l" + this.secondsLeft + " seconds\u00a77...");
                --this.secondsLeft;
            }
        }.runTaskTimer((Plugin)this.getPlugin(), 0L, 20L);
    }
}

