/*
 * Decompiled with CFR 0.152.
 */
package net.devscape.project.guilds;

import java.util.Optional;
import net.devscape.project.guilds.Guilds;
import net.devscape.project.guilds.commands.AcceptInvite;
import net.devscape.project.guilds.commands.Chat;
import net.devscape.project.guilds.commands.Confirmation;
import net.devscape.project.guilds.commands.CreateGuild;
import net.devscape.project.guilds.commands.DenyInvite;
import net.devscape.project.guilds.commands.DisbandGuild;
import net.devscape.project.guilds.commands.GetGuildInfo;
import net.devscape.project.guilds.commands.GoToWarp;
import net.devscape.project.guilds.commands.InvitePlayer;
import net.devscape.project.guilds.commands.LeaveGuild;
import net.devscape.project.guilds.commands.ListGuilds;
import net.devscape.project.guilds.commands.Reload;
import net.devscape.project.guilds.commands.SetDescription;
import net.devscape.project.guilds.commands.SetWarp;
import net.devscape.project.guilds.commands.Upgrade;
import net.devscape.project.guilds.handlers.Guild;
import net.devscape.project.guilds.menus.pages.GuildMenu;
import net.devscape.project.guilds.util.InputChecker;
import net.devscape.project.guilds.util.Message;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class CommandHandler
implements CommandExecutor {
    private final Guilds plugin;

    public CommandHandler(Guilds plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("guilds")) {
            return false;
        }
        if (sender instanceof ConsoleCommandSender) {
            Message.sendHelp(this.plugin, sender, "help", label);
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            Optional<Guild> guild = this.plugin.getData().getGuild(player.getUniqueId());
            if (guild.isPresent()) {
                new GuildMenu(Guilds.getMenuUtil(player, guild.get())).open();
            } else {
                Message.sendHelp(this.plugin, sender, "help", label);
            }
            return true;
        }
        if (InputChecker.noSpecialCharacters(args)) {
            this.parseSubCommand(sender, args, label);
        } else if (args[0].equalsIgnoreCase("setdesc")) {
            this.parseSubCommand(sender, args, label);
        } else {
            Message.send(this.plugin, sender, "no-special-characters");
        }
        return true;
    }

    private void parseSubCommand(CommandSender sender, String[] args, String label) {
        if (args[0].equalsIgnoreCase("create")) {
            this.guildCreate(sender, args, label);
        } else if (args[0].equalsIgnoreCase("disband")) {
            this.guildDisband(sender, args, label);
        } else if (args[0].equalsIgnoreCase("warp")) {
            this.guildWarp(sender, args, label);
        } else if (args[0].equalsIgnoreCase("invite")) {
            this.guildInvite(sender, args, label);
        } else if (args[0].equalsIgnoreCase("chat")) {
            this.guildChat(sender, args, label);
        } else if (args[0].equalsIgnoreCase("deny")) {
            this.guildDeny(sender, args, label);
        } else if (args[0].equalsIgnoreCase("list")) {
            new ListGuilds(this.plugin, sender, args);
        } else if (args[0].equalsIgnoreCase("reload")) {
            new Reload(this.plugin, sender, args);
        } else if (args[0].equalsIgnoreCase("setdesc")) {
            this.guildSetDesc(sender, args, label);
        } else if (args[0].equalsIgnoreCase("setwarp")) {
            this.guildSetWarp(sender, args, label);
        } else if (args[0].equalsIgnoreCase("upgrade")) {
            this.guildUpgrade(sender, args, label);
        } else if (args[0].equalsIgnoreCase("confirm")) {
            this.guildConfirmInvite(sender, args, label);
        } else if (args[0].equalsIgnoreCase("leave")) {
            this.guildLeave(sender, args, label);
        } else if (args[0].equalsIgnoreCase("accept")) {
            this.guildAccept(sender, args, label);
        } else if (args.length == 1) {
            this.guildInfo(sender, args, label);
        }
    }

    private void guildLeave(CommandSender sender, String[] args, String label) {
        if (args.length == 1) {
            new LeaveGuild(this.plugin, sender, args);
        } else {
            Message.sendPlaceholder(this.plugin, sender, "syntax.leave", label);
        }
    }

    private void guildChat(CommandSender sender, String[] args, String label) {
        if (args.length >= 2) {
            new Chat(this.plugin, sender, args);
        } else {
            Message.sendPlaceholder(this.plugin, sender, "syntax.chat", label);
        }
    }

    private void guildConfirmInvite(CommandSender sender, String[] args, String label) {
        if (args.length == 1) {
            new Confirmation(this.plugin, sender, args);
        } else {
            Message.sendPlaceholder(this.plugin, sender, "syntax.confirm", label);
        }
    }

    private void guildUpgrade(CommandSender sender, String[] args, String label) {
        if (args.length == 1) {
            new Upgrade(this.plugin, sender, args, label);
        } else {
            Message.sendPlaceholder(this.plugin, sender, "syntax.upgrade", label);
        }
    }

    private void guildSetWarp(CommandSender sender, String[] args, String label) {
        if (args.length == 2) {
            new SetWarp(this.plugin, sender, args);
        } else {
            Message.sendPlaceholder(this.plugin, sender, "syntax.setwarp", label);
        }
    }

    private void guildSetDesc(CommandSender sender, String[] args, String label) {
        if (args.length >= 2) {
            new SetDescription(this.plugin, sender, args);
        } else {
            Message.sendPlaceholder(this.plugin, sender, "syntax.setdesc", label);
        }
    }

    private void guildReload(CommandSender sender, String[] args, String label) {
        new Reload(this.plugin, sender, args);
    }

    private void guildInfo(CommandSender sender, String[] args, String label) {
        if (args.length == 1) {
            new GetGuildInfo(this.plugin, sender, args);
        } else {
            Message.sendPlaceholder(this.plugin, sender, "messages.guild-not-found", label);
        }
    }

    private void guildAccept(CommandSender sender, String[] args, String label) {
        if (args.length == 2) {
            new AcceptInvite(this.plugin, sender, args);
        } else {
            Message.sendPlaceholder(this.plugin, sender, "syntax.accept-invite", label);
        }
    }

    private void guildDeny(CommandSender sender, String[] args, String label) {
        if (args.length == 2) {
            new DenyInvite(this.plugin, sender, args);
        } else {
            Message.sendPlaceholder(this.plugin, sender, "syntax.deny-invite", label);
        }
    }

    private void guildCreate(CommandSender sender, String[] args, String label) {
        if (args.length == 2) {
            new CreateGuild(this.plugin, sender, args);
        } else {
            Message.sendPlaceholder(this.plugin, sender, "syntax.create", label);
        }
    }

    private void guildDisband(CommandSender sender, String[] args, String label) {
        if (args.length == 1) {
            new DisbandGuild(this.plugin, sender, args);
        } else {
            Message.sendPlaceholder(this.plugin, sender, "syntax.disband", label);
        }
    }

    private void guildWarp(CommandSender sender, String[] args, String label) {
        if (args.length == 2) {
            new GoToWarp(this.plugin, sender, args);
        } else {
            Message.sendPlaceholder(this.plugin, sender, "syntax.warp", label);
        }
    }

    private void guildInvite(CommandSender sender, String[] args, String label) {
        if (args.length == 2) {
            new InvitePlayer(this.plugin, sender, args);
        } else {
            Message.sendPlaceholder(this.plugin, sender, "syntax.invite", label);
        }
    }
}

