/*
 * Decompiled with CFR 0.152.
 */
package net.devscape.project.guilds.storage.file;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.devscape.project.guilds.handlers.GPlayer;
import net.devscape.project.guilds.handlers.Guild;
import net.devscape.project.guilds.handlers.Role;

public class FileCache {
    private final Map<UUID, GPlayer> players = new HashMap<UUID, GPlayer>();
    private final Map<String, Guild> guilds = new HashMap<String, Guild>();
    private final Map<UUID, Double> transactionConfirmations = new HashMap<UUID, Double>();

    public void addPlayer(UUID uuid, String guildId, Role role) {
        this.players.put(uuid, new GPlayer(uuid, guildId, role));
    }

    public Optional<GPlayer> getPlayer(UUID uuid) {
        if (this.players.containsKey(uuid)) {
            return Optional.of(this.players.get(uuid));
        }
        return Optional.empty();
    }

    public void removePlayer(UUID uuid) {
        this.players.remove(uuid);
    }

    public boolean playerExists(UUID uuid) {
        return this.players.containsKey(uuid);
    }

    public boolean guildExists(String guildId) {
        return this.guilds.containsKey(guildId);
    }

    public void addGuild(Guild guild) {
        this.guilds.put(guild.getName(), guild);
    }

    public void removeGuild(String id) {
        this.guilds.remove(id);
    }

    public Optional<Guild> getGuild(String id) {
        if (this.guilds.containsKey(id)) {
            return Optional.of(this.guilds.get(id));
        }
        return Optional.empty();
    }

    public Map<String, Guild> getGuilds() {
        return this.guilds;
    }

    public Map<UUID, GPlayer> getPlayers() {
        return this.players;
    }

    public void addTransactionConfirmation(UUID uuid, double value) {
        this.transactionConfirmations.put(uuid, value);
    }

    public double getTransactionAmount(UUID uuid) {
        return this.transactionConfirmations.get(uuid);
    }

    public boolean hasTransactionConfirmation(UUID uuid) {
        return this.transactionConfirmations.containsKey(uuid);
    }
}

