/*
 * Decompiled with CFR 0.152.
 */
package net.devscape.project.guilds.menus;

import java.util.Arrays;
import java.util.List;
import net.devscape.project.guilds.menus.MenuUtil;
import net.devscape.project.guilds.util.Message;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class Menu
implements InventoryHolder {
    protected Inventory inventory;
    protected MenuUtil menuUtil;

    public Menu(MenuUtil menuUtil) {
        this.menuUtil = menuUtil;
    }

    public abstract String getMenuName();

    public abstract int getSlots();

    public abstract void handleMenu(InventoryClickEvent var1);

    public abstract void setMenuItems();

    public void open() {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.getSlots(), (String)this.getMenuName());
        this.setMenuItems();
        this.menuUtil.getOwner().openInventory(this.inventory);
    }

    public void refresh() {
        this.menuUtil.getOwner().updateInventory();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void fillEmpty() {
        for (int slot = 0; slot < this.inventory.getSize(); ++slot) {
            if (this.inventory.getItem(slot) != null) continue;
            this.inventory.setItem(slot, this.makeItem(Material.GRAY_STAINED_GLASS_PANE, Message.format("&8"), new String[0]));
        }
    }

    public ItemStack makeItem(Material material, String displayName, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta itemMeta = item.getItemMeta();
        assert (itemMeta != null);
        itemMeta.setDisplayName(displayName);
        itemMeta.setLore(Arrays.asList(lore));
        item.setItemMeta(itemMeta);
        return item;
    }

    public ItemStack makeItem(Material material, String displayName, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta itemMeta = item.getItemMeta();
        assert (itemMeta != null);
        itemMeta.setDisplayName(displayName);
        itemMeta.setLore(lore);
        item.setItemMeta(itemMeta);
        return item;
    }
}

