/*
 * Decompiled with CFR 0.152.
 */
package net.devscape.project.guilds.handlers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.devscape.project.guilds.handlers.Role;
import net.devscape.project.guilds.handlers.Warp;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Guild
implements Comparable<Guild> {
    private String name;
    private UUID owner;
    private String description;
    private Map<UUID, Role> members;
    private Map<String, Warp> warps;
    private int level;

    public Guild(UUID owner, String name) {
        this.owner = owner;
        this.name = name;
        this.members = new HashMap<UUID, Role>();
        this.members.put(owner, Role.LEADER);
        this.warps = new HashMap<String, Warp>();
        this.description = "A new guild!";
        this.level = 1;
    }

    public Guild(String name) {
        this.owner = null;
        this.name = name;
        this.members = new HashMap<UUID, Role>();
        this.warps = new HashMap<String, Warp>();
        this.description = "A new guild!";
        this.level = 1;
    }

    public Guild(String name, UUID ownerId, String description, List<Object> memberObjects, Object warps, int level) {
        this.members = new HashMap<UUID, Role>();
        this.warps = new HashMap<String, Warp>();
        this.name = name;
        this.owner = ownerId;
        this.description = description;
        memberObjects.forEach(member -> this._addMember((JSONObject)member));
        ((JSONArray)warps).forEach(warp -> this._addWarps((JSONObject)warp));
        this.level = level;
    }

    private void _addMember(JSONObject member) {
        String id = String.valueOf(member.get((Object)"player"));
        String role = String.valueOf(member.get((Object)"role"));
        this.members.put(UUID.fromString(id), Role.valueOf(role));
    }

    private void _addWarps(JSONObject warp) {
        String name = String.valueOf(warp.get((Object)"name"));
        String world = String.valueOf(warp.get((Object)"world"));
        double x = (Double)warp.get((Object)"x");
        double y = (Double)warp.get((Object)"y");
        double z = (Double)warp.get((Object)"z");
        double yaw = (Double)warp.get((Object)"yaw");
        double pitch = (Double)warp.get((Object)"pitch");
        this.warps.put(name, new Warp(name, world, x, y, z, (float)yaw, (float)pitch));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<UUID, Role> getMembers() {
        return this.members;
    }

    public boolean isOwner(UUID playerUuid) {
        return playerUuid.equals(this.owner);
    }

    public boolean containsMember(UUID playerUuid) {
        return this.members.containsKey(playerUuid);
    }

    public boolean containsWarp(String name) {
        return this.warps.get(name) != null;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public Map<String, Warp> getWarps() {
        return this.warps;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        if (level >= 1 && level <= 10) {
            this.level = level;
        } else {
            if (level < 1) {
                this.level = 1;
            }
            if (level > 10) {
                this.level = 10;
            }
        }
    }

    public int getMaxWarps() {
        return this.level;
    }

    public int getMaxMembers() {
        return this.level * 3;
    }

    public int getMaxLevel() {
        return 10;
    }

    public String toString() {
        JSONObject json = new JSONObject();
        json.put((Object)"name", (Object)this.name);
        if (this.owner != null) {
            json.put((Object)"owner", (Object)this.owner.toString());
        }
        json.put((Object)"description", (Object)this.description);
        JSONArray jsonArray = new JSONArray();
        if (this.members != null) {
            for (UUID member : this.members.keySet()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"player", (Object)member.toString());
                jsonObject.put((Object)"role", (Object)this.members.get(member).toString());
                jsonArray.add((Object)jsonObject);
            }
            json.put((Object)"members", (Object)jsonArray);
        }
        JSONArray warpArray = new JSONArray();
        for (String key : this.warps.keySet()) {
            Warp location = this.warps.get(key);
            String world = location.getWorld();
            double x = location.getX();
            double y = location.getY();
            double z = location.getZ();
            double yaw = location.getYaw();
            double pitch = location.getPitch();
            JSONObject jsonObject2 = new JSONObject();
            jsonObject2.put((Object)"name", (Object)key);
            jsonObject2.put((Object)"world", (Object)world);
            jsonObject2.put((Object)"x", (Object)x);
            jsonObject2.put((Object)"y", (Object)y);
            jsonObject2.put((Object)"z", (Object)z);
            jsonObject2.put((Object)"yaw", (Object)yaw);
            jsonObject2.put((Object)"pitch", (Object)pitch);
            warpArray.add((Object)jsonObject2);
        }
        json.put((Object)"warps", (Object)warpArray);
        json.put((Object)"level", (Object)this.level);
        return json.toString();
    }

    @Override
    public int compareTo(Guild o) {
        if (this.members.size() > o.getMembers().size()) {
            return 1;
        }
        return -1;
    }

    public void setMembers(Map<UUID, Role> members) {
        this.members = members;
    }

    public void setWarps(Map<String, Warp> warps) {
        this.warps = warps;
    }

    public void addMember(UUID uuid) {
        this.members.put(uuid, Role.MEMBER);
    }

    public void removeMember(UUID uuid) {
        this.members.remove(uuid);
    }

    public void addWarp(Warp warp) {
        this.warps.put(warp.getId(), warp);
    }

    public void removeWarp(String id) {
        this.warps.remove(id);
    }

    public void updateWarp(Warp warp) {
        this.warps.replace(warp.getId(), warp);
    }
}

