/*
 * Decompiled with CFR 0.152.
 */
package net.devscape.project.guilds.commands;

import java.util.Objects;
import java.util.Optional;
import net.devscape.project.guilds.Guilds;
import net.devscape.project.guilds.SubCommand;
import net.devscape.project.guilds.handlers.Guild;
import net.devscape.project.guilds.util.Message;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetWarp
extends SubCommand {
    public SetWarp(Guilds plugin, CommandSender sender, String[] args) {
        super(plugin, sender, args);
        this.execute();
    }

    private void execute() {
        Player player = (Player)this.getSender();
        try {
            String warpName = this.getArgs()[1];
            Optional<Guild> guild = this.getPlugin().getData().getGuild(player.getUniqueId());
            if (!guild.isPresent()) {
                Message.send(this.getPlugin(), this.getSender(), "must-be-owner");
                return;
            }
            if (guild.get().isOwner(player.getUniqueId())) {
                Location loc = player.getLocation();
                this.getPlugin().getData().saveWarp(warpName, Objects.requireNonNull(loc.getWorld()).getName(), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch(), guild.get().getName());
                Message.sendPlaceholder(this.getPlugin(), this.getSender(), "set-warp", warpName);
            } else {
                Message.send(this.getPlugin(), this.getSender(), "must-be-owner");
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            Message.send(this.getPlugin(), this.getSender(), "generic-error");
        }
    }
}

