/*
 * Decompiled with CFR 0.152.
 */
package net.devscape.project.guilds.commands;

import java.util.Collections;
import java.util.List;
import net.devscape.project.guilds.Guilds;
import net.devscape.project.guilds.SubCommand;
import net.devscape.project.guilds.handlers.Guild;
import net.devscape.project.guilds.util.Message;
import org.bukkit.command.CommandSender;

public class ListGuilds
extends SubCommand {
    public ListGuilds(Guilds plugin, CommandSender sender, String[] args) {
        super(plugin, sender, args);
        this.execute();
    }

    private boolean execute() {
        List<Guild> guildList = this.getPlugin().getData().getAllGuilds();
        Collections.sort(guildList);
        if (guildList.size() == 0) {
            Message.send(this.getPlugin(), this.getSender(), "no-guilds");
            return false;
        }
        Message.send(this.getPlugin(), this.getSender(), "guild-list-header");
        int listSize = Math.min(guildList.size(), 10);
        for (int i = 0; i < listSize; ++i) {
            Guild guild = guildList.get(i);
            String[] placeholders = new String[]{String.valueOf(i + 1), guild.getName(), String.valueOf(guild.getMembers().size())};
            Message.sendGuildList(this.getPlugin(), this.getSender(), "guild-list-line", placeholders);
        }
        return true;
    }
}

