/*
 * Decompiled with CFR 0.152.
 */
package net.devscape.project.guilds.commands;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.devscape.project.guilds.Guilds;
import net.devscape.project.guilds.SubCommand;
import net.devscape.project.guilds.handlers.GPlayer;
import net.devscape.project.guilds.handlers.Guild;
import net.devscape.project.guilds.handlers.Role;
import net.devscape.project.guilds.util.Message;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AcceptInvite
extends SubCommand {
    public AcceptInvite(Guilds plugin, CommandSender sender, String[] args) {
        super(plugin, sender, args);
        this.execute();
    }

    private boolean execute() {
        Player player2 = (Player)this.getSender();
        String guildName = this.getArgs()[1];
        boolean noGuild = !this.getPlugin().getData().getGuild(player2.getUniqueId()).isPresent();
        boolean invited = this.getPlugin().getData().hasInvite(player2.getUniqueId(), guildName);
        if (!invited) {
            Message.sendPlaceholder(this.getPlugin(), this.getSender(), "no-invite", guildName);
            return false;
        }
        Optional<Guild> guild = this.getPlugin().getData().getGuild(guildName);
        boolean guildExists = guild.isPresent();
        if (guildExists && noGuild) {
            this.getPlugin().getData().savePlayer(new GPlayer(player2.getUniqueId(), guildName, Role.MEMBER));
            Message.sendPlaceholder(this.getPlugin(), this.getSender(), "invite-accepted", guild.get().getName());
            this.getPlugin().getData().deleteInvite(player2.getUniqueId(), guildName);
            if (Bukkit.getPlayer((UUID)guild.get().getOwner()) != null) {
                Message.sendPlaceholder(this.getPlugin(), Objects.requireNonNull(Bukkit.getPlayer((UUID)guild.get().getOwner())), "player-joined-guild", player2.getName());
            }
        } else if (!guildExists) {
            player2.sendMessage(guildName + " does not exist anymore!");
        } else {
            Message.send(this.getPlugin(), this.getSender(), "already-in-guild");
        }
        return true;
    }
}

