/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.MinecraftMessageKeys;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ACFBukkitUtil {
    public static String formatLocation(Location loc) {
        if (loc == null) {
            return null;
        }
        return loc.getWorld().getName() + ":" + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    public static String color(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    @Deprecated
    public static void sendMsg(CommandSender player, String message) {
        message = ACFBukkitUtil.color(message);
        for (String msg : ACFPatterns.NEWLINE.split(message)) {
            player.sendMessage(msg);
        }
    }

    public static Location stringToLocation(String storedLoc) {
        return ACFBukkitUtil.stringToLocation(storedLoc, null);
    }

    public static Location stringToLocation(String storedLoc, World forcedWorld) {
        String[] args2;
        if (storedLoc == null) {
            return null;
        }
        String[] args3 = ACFPatterns.COLON.split(storedLoc);
        if (args3.length >= 4 || args3.length == 3 && forcedWorld != null) {
            String world = forcedWorld != null ? forcedWorld.getName() : args3[0];
            int i = args3.length == 3 ? 0 : 1;
            double x = Double.parseDouble(args3[i]);
            double y = Double.parseDouble(args3[i + 1]);
            double z = Double.parseDouble(args3[i + 2]);
            Location loc = new Location(Bukkit.getWorld((String)world), x, y, z);
            if (args3.length >= 6) {
                loc.setPitch(Float.parseFloat(args3[4]));
                loc.setYaw(Float.parseFloat(args3[5]));
            }
            return loc;
        }
        if (args3.length == 2 && (args2 = ACFPatterns.COMMA.split(args3[1])).length == 3) {
            String world = forcedWorld != null ? forcedWorld.getName() : args3[0];
            double x = Double.parseDouble(args2[0]);
            double y = Double.parseDouble(args2[1]);
            double z = Double.parseDouble(args2[2]);
            return new Location(Bukkit.getWorld((String)world), x, y, z);
        }
        return null;
    }

    public static String fullLocationToString(Location loc) {
        if (loc == null) {
            return null;
        }
        return new StringBuilder(64).append(loc.getWorld().getName()).append(':').append(ACFUtil.precision(loc.getX(), 4)).append(':').append(ACFUtil.precision(loc.getY(), 4)).append(':').append(ACFUtil.precision(loc.getZ(), 4)).append(':').append(ACFUtil.precision(loc.getPitch(), 4)).append(':').append(ACFUtil.precision(loc.getYaw(), 4)).toString();
    }

    public static String fullBlockLocationToString(Location loc) {
        if (loc == null) {
            return null;
        }
        return new StringBuilder(64).append(loc.getWorld().getName()).append(':').append(loc.getBlockX()).append(':').append(loc.getBlockY()).append(':').append(loc.getBlockZ()).append(':').append(ACFUtil.precision(loc.getPitch(), 4)).append(':').append(ACFUtil.precision(loc.getYaw(), 4)).toString();
    }

    public static String blockLocationToString(Location loc) {
        if (loc == null) {
            return null;
        }
        return new StringBuilder(32).append(loc.getWorld().getName()).append(':').append(loc.getBlockX()).append(':').append(loc.getBlockY()).append(':').append(loc.getBlockZ()).toString();
    }

    public static double distance(@NotNull Entity e1, @NotNull Entity e2) {
        return ACFBukkitUtil.distance(e1.getLocation(), e2.getLocation());
    }

    public static double distance2d(@NotNull Entity e1, @NotNull Entity e2) {
        return ACFBukkitUtil.distance2d(e1.getLocation(), e2.getLocation());
    }

    public static double distance2d(@NotNull Location loc1, @NotNull Location loc2) {
        loc1 = loc1.clone();
        loc1.setY(loc2.getY());
        return ACFBukkitUtil.distance(loc1, loc2);
    }

    public static double distance(@NotNull Location loc1, @NotNull Location loc2) {
        if (loc1.getWorld() != loc2.getWorld()) {
            return 0.0;
        }
        return loc1.distance(loc2);
    }

    public static Location getTargetLoc(Player player) {
        return ACFBukkitUtil.getTargetLoc(player, 128);
    }

    public static Location getTargetLoc(Player player, int maxDist) {
        return ACFBukkitUtil.getTargetLoc(player, maxDist, 1.5);
    }

    public static Location getTargetLoc(Player player, int maxDist, double addY) {
        try {
            Location target = player.getTargetBlock((Set)null, maxDist).getLocation();
            target.setY(target.getY() + addY);
            return target;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static Location getRandLoc(Location loc, int radius) {
        return ACFBukkitUtil.getRandLoc(loc, radius, radius, radius);
    }

    public static Location getRandLoc(Location loc, int xzRadius, int yRadius) {
        return ACFBukkitUtil.getRandLoc(loc, xzRadius, yRadius, xzRadius);
    }

    @NotNull
    public static Location getRandLoc(Location loc, int xRadius, int yRadius, int zRadius) {
        Location newLoc = loc.clone();
        newLoc.setX(ACFUtil.rand(loc.getX() - (double)xRadius, loc.getX() + (double)xRadius));
        newLoc.setY(ACFUtil.rand(loc.getY() - (double)yRadius, loc.getY() + (double)yRadius));
        newLoc.setZ(ACFUtil.rand(loc.getZ() - (double)zRadius, loc.getZ() + (double)zRadius));
        return newLoc;
    }

    public static String removeColors(String msg) {
        return ChatColor.stripColor((String)ACFBukkitUtil.color(msg));
    }

    public static String replaceChatString(String message, String replace, String with) {
        return ACFBukkitUtil.replaceChatString(message, Pattern.compile(Pattern.quote(replace), 2), with);
    }

    public static String replaceChatString(String message, Pattern replace, String with) {
        String[] split = replace.split(message + "1");
        if (split.length < 2) {
            return replace.matcher(message).replaceAll(with);
        }
        message = split[0];
        for (int i = 1; i < split.length; ++i) {
            String prev = ChatColor.getLastColors((String)message);
            message = message + with + prev + split[i];
        }
        return message.substring(0, message.length() - 1);
    }

    public static boolean isWithinDistance(@NotNull Player p1, @NotNull Player p2, int dist) {
        return ACFBukkitUtil.isWithinDistance(p1.getLocation(), p2.getLocation(), dist);
    }

    public static boolean isWithinDistance(@NotNull Location loc1, @NotNull Location loc2, int dist) {
        return loc1.getWorld() == loc2.getWorld() && loc1.distance(loc2) <= (double)dist;
    }

    public static Player findPlayerSmart(CommandSender requester, String search) {
        CommandManager manager = CommandManager.getCurrentCommandManager();
        if (manager != null) {
            return ACFBukkitUtil.findPlayerSmart(manager.getCommandIssuer(requester), search);
        }
        throw new IllegalStateException("You may not use the ACFBukkitUtil#findPlayerSmart(CommandSender) async to the command execution.");
    }

    public static Player findPlayerSmart(CommandIssuer issuer, String search) {
        CommandSender requester = (CommandSender)issuer.getIssuer();
        if (search == null) {
            return null;
        }
        String name = ACFUtil.replace(search, ":confirm", "");
        List matches = Bukkit.getServer().matchPlayer(name);
        ArrayList<Player> confirmList = new ArrayList<Player>();
        ACFBukkitUtil.findMatches(search, requester, matches, confirmList);
        if (matches.size() > 1 || confirmList.size() > 1) {
            String allMatches = matches.stream().map(OfflinePlayer::getName).collect(Collectors.joining(", "));
            issuer.sendError(MinecraftMessageKeys.MULTIPLE_PLAYERS_MATCH, "{search}", name, "{all}", allMatches);
            return null;
        }
        if (matches.isEmpty()) {
            if (!ACFBukkitUtil.isValidName(name)) {
                issuer.sendError(MinecraftMessageKeys.IS_NOT_A_VALID_NAME, "{name}", name);
                return null;
            }
            Player player = ACFUtil.getFirstElement(confirmList);
            if (player == null) {
                issuer.sendError(MinecraftMessageKeys.NO_PLAYER_FOUND_SERVER, "{search}", name);
                return null;
            }
            issuer.sendInfo(MinecraftMessageKeys.PLAYER_IS_VANISHED_CONFIRM, "{vanished}", player.getName());
            return null;
        }
        return (Player)matches.get(0);
    }

    private static void findMatches(String search, CommandSender requester, List<Player> matches, List<Player> confirmList) {
        Iterator<Player> iter = matches.iterator();
        while (iter.hasNext()) {
            Player player = iter.next();
            if (!(requester instanceof Player) || ((Player)requester).canSee(player)) continue;
            if (requester.hasPermission("acf.seevanish")) {
                if (search.endsWith(":confirm")) continue;
                confirmList.add(player);
                iter.remove();
                continue;
            }
            iter.remove();
        }
    }

    public static boolean isValidName(String name) {
        return name != null && !name.isEmpty() && ACFPatterns.VALID_NAME_PATTERN.matcher(name).matches();
    }

    static boolean isValidItem(ItemStack item) {
        return item != null && item.getType() != Material.AIR && item.getAmount() > 0;
    }
}

