/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.nmsutil;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.Pair;
import org.bukkit.util.Vector;

public class ReachUtils {
    public static Pair<Vector, BlockFace> calculateIntercept(SimpleCollisionBox self, Vector origin, Vector end) {
        Vector minX = ReachUtils.getIntermediateWithXValue(origin, end, self.minX);
        Vector maxX = ReachUtils.getIntermediateWithXValue(origin, end, self.maxX);
        Vector minY = ReachUtils.getIntermediateWithYValue(origin, end, self.minY);
        Vector maxY = ReachUtils.getIntermediateWithYValue(origin, end, self.maxY);
        Vector minZ = ReachUtils.getIntermediateWithZValue(origin, end, self.minZ);
        Vector maxZ = ReachUtils.getIntermediateWithZValue(origin, end, self.maxZ);
        BlockFace bestFace = null;
        if (!ReachUtils.isVecInYZ(self, minX)) {
            minX = null;
        }
        if (!ReachUtils.isVecInYZ(self, maxX)) {
            maxX = null;
        }
        if (!ReachUtils.isVecInXZ(self, minY)) {
            minY = null;
        }
        if (!ReachUtils.isVecInXZ(self, maxY)) {
            maxY = null;
        }
        if (!ReachUtils.isVecInXY(self, minZ)) {
            minZ = null;
        }
        if (!ReachUtils.isVecInXY(self, maxZ)) {
            maxZ = null;
        }
        Vector best = null;
        if (minX != null) {
            best = minX;
            bestFace = BlockFace.WEST;
        }
        if (maxX != null && (best == null || origin.distanceSquared(maxX) < origin.distanceSquared(best))) {
            best = maxX;
            bestFace = BlockFace.EAST;
        }
        if (minY != null && (best == null || origin.distanceSquared(minY) < origin.distanceSquared(best))) {
            best = minY;
            bestFace = BlockFace.DOWN;
        }
        if (maxY != null && (best == null || origin.distanceSquared(maxY) < origin.distanceSquared(best))) {
            best = maxY;
            bestFace = BlockFace.UP;
        }
        if (minZ != null && (best == null || origin.distanceSquared(minZ) < origin.distanceSquared(best))) {
            best = minZ;
            bestFace = BlockFace.NORTH;
        }
        if (maxZ != null && (best == null || origin.distanceSquared(maxZ) < origin.distanceSquared(best))) {
            best = maxZ;
            bestFace = BlockFace.SOUTH;
        }
        return new Pair<Vector, BlockFace>(best, bestFace);
    }

    public static Vector getIntermediateWithXValue(Vector self, Vector other, double x) {
        double d0 = other.getX() - self.getX();
        double d1 = other.getY() - self.getY();
        double d2 = other.getZ() - self.getZ();
        if (d0 * d0 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (x - self.getX()) / d0;
        return d3 >= 0.0 && d3 <= 1.0 ? new Vector(self.getX() + d0 * d3, self.getY() + d1 * d3, self.getZ() + d2 * d3) : null;
    }

    public static Vector getIntermediateWithYValue(Vector self, Vector other, double y) {
        double d0 = other.getX() - self.getX();
        double d1 = other.getY() - self.getY();
        double d2 = other.getZ() - self.getZ();
        if (d1 * d1 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (y - self.getY()) / d1;
        return d3 >= 0.0 && d3 <= 1.0 ? new Vector(self.getX() + d0 * d3, self.getY() + d1 * d3, self.getZ() + d2 * d3) : null;
    }

    public static Vector getIntermediateWithZValue(Vector self, Vector other, double z) {
        double d0 = other.getX() - self.getX();
        double d1 = other.getY() - self.getY();
        double d2 = other.getZ() - self.getZ();
        if (d2 * d2 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (z - self.getZ()) / d2;
        return d3 >= 0.0 && d3 <= 1.0 ? new Vector(self.getX() + d0 * d3, self.getY() + d1 * d3, self.getZ() + d2 * d3) : null;
    }

    private static boolean isVecInYZ(SimpleCollisionBox self, Vector vec) {
        return vec != null && vec.getY() >= self.minY && vec.getY() <= self.maxY && vec.getZ() >= self.minZ && vec.getZ() <= self.maxZ;
    }

    private static boolean isVecInXZ(SimpleCollisionBox self, Vector vec) {
        return vec != null && vec.getX() >= self.minX && vec.getX() <= self.maxX && vec.getZ() >= self.minZ && vec.getZ() <= self.maxZ;
    }

    private static boolean isVecInXY(SimpleCollisionBox self, Vector vec) {
        return vec != null && vec.getX() >= self.minX && vec.getX() <= self.maxX && vec.getY() >= self.minY && vec.getY() <= self.maxY;
    }

    public static Vector getLook(GrimPlayer player, float yaw, float pitch) {
        if (player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_12_2)) {
            float f = player.trigHandler.cos(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
            float f1 = player.trigHandler.sin(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
            float f2 = -player.trigHandler.cos(-pitch * ((float)Math.PI / 180));
            float f3 = player.trigHandler.sin(-pitch * ((float)Math.PI / 180));
            return new Vector(f1 * f2, f3, f * f2);
        }
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = player.trigHandler.cos(f1);
        float f3 = player.trigHandler.sin(f1);
        float f4 = player.trigHandler.cos(f);
        float f5 = player.trigHandler.sin(f);
        return new Vector((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static boolean isVecInside(SimpleCollisionBox self, Vector vec) {
        return vec.getX() > self.minX && vec.getX() < self.maxX && vec.getY() > self.minY && vec.getY() < self.maxY && vec.getZ() > self.minZ && vec.getZ() < self.maxZ;
    }
}

