/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.nmsutil;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.data.packetentity.PacketEntityHorse;
import ac.grim.grimac.utils.data.packetentity.PacketEntitySizeable;
import ac.grim.grimac.utils.data.packetentity.PacketEntityTrackXRot;

public class BoundingBoxSize {
    public static float getWidth(GrimPlayer player, PacketEntity packetEntity) {
        if (packetEntity.type == EntityTypes.TURTLE && packetEntity.isBaby) {
            return 0.36f;
        }
        return BoundingBoxSize.getWidthMinusBaby(player, packetEntity) * (packetEntity.isBaby ? 0.5f : 1.0f);
    }

    private static float getWidthMinusBaby(GrimPlayer player, PacketEntity packetEntity) {
        if (EntityTypes.AXOLOTL.equals(packetEntity.type) || EntityTypes.PANDA.equals(packetEntity.type)) {
            return 1.3f;
        }
        if (EntityTypes.BAT.equals(packetEntity.type) || EntityTypes.PARROT.equals(packetEntity.type) || EntityTypes.COD.equals(packetEntity.type) || EntityTypes.EVOKER_FANGS.equals(packetEntity.type) || EntityTypes.TROPICAL_FISH.equals(packetEntity.type) || EntityTypes.FROG.equals(packetEntity.type)) {
            return 0.5f;
        }
        if (EntityTypes.BEE.equals(packetEntity.type) || EntityTypes.PUFFERFISH.equals(packetEntity.type) || EntityTypes.SALMON.equals(packetEntity.type) || EntityTypes.SNOW_GOLEM.equals(packetEntity.type) || EntityTypes.CAVE_SPIDER.equals(packetEntity.type)) {
            return 0.7f;
        }
        if (EntityTypes.WITHER_SKELETON.equals(packetEntity.type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 0.7f : 0.72f;
        }
        if (EntityTypes.WITHER_SKULL.equals(packetEntity.type) || EntityTypes.SHULKER_BULLET.equals(packetEntity.type)) {
            return 0.3125f;
        }
        if (EntityTypes.HOGLIN.equals(packetEntity.type) || EntityTypes.SKELETON_HORSE.equals(packetEntity.type) || EntityTypes.MULE.equals(packetEntity.type) || EntityTypes.ZOMBIE_HORSE.equals(packetEntity.type) || EntityTypes.HORSE.equals(packetEntity.type) || EntityTypes.ZOGLIN.equals(packetEntity.type)) {
            return 1.39648f;
        }
        if (EntityTypes.isTypeInstanceOf(packetEntity.type, EntityTypes.BOAT)) {
            return 1.375f;
        }
        if (EntityTypes.CHICKEN.equals(packetEntity.type) || EntityTypes.ENDERMITE.equals(packetEntity.type) || EntityTypes.SILVERFISH.equals(packetEntity.type) || EntityTypes.VEX.equals(packetEntity.type) || EntityTypes.TADPOLE.equals(packetEntity.type)) {
            return 0.4f;
        }
        if (EntityTypes.RABBIT.equals(packetEntity.type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 0.4f : 0.6f;
        }
        if (EntityTypes.STRIDER.equals(packetEntity.type) || EntityTypes.COW.equals(packetEntity.type) || EntityTypes.SHEEP.equals(packetEntity.type) || EntityTypes.MOOSHROOM.equals(packetEntity.type) || EntityTypes.PIG.equals(packetEntity.type) || EntityTypes.LLAMA.equals(packetEntity.type) || EntityTypes.DOLPHIN.equals(packetEntity.type) || EntityTypes.WITHER.equals(packetEntity.type) || EntityTypes.TRADER_LLAMA.equals(packetEntity.type) || EntityTypes.WARDEN.equals(packetEntity.type) || EntityTypes.GOAT.equals(packetEntity.type)) {
            return 0.9f;
        }
        if (EntityTypes.PHANTOM.equals(packetEntity.type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                return 0.9f + (float)((PacketEntitySizeable)packetEntity).size * 0.2f;
            }
            return 1.5f;
        }
        if (EntityTypes.DONKEY.equals(packetEntity.type)) {
            return 1.3964844f;
        }
        if (EntityTypes.ELDER_GUARDIAN.equals(packetEntity.type)) {
            return 1.9975f;
        }
        if (EntityTypes.END_CRYSTAL.equals(packetEntity.type)) {
            return 2.0f;
        }
        if (EntityTypes.ENDER_DRAGON.equals(packetEntity.type)) {
            return 16.0f;
        }
        if (EntityTypes.FIREBALL.equals(packetEntity.type)) {
            return 1.0f;
        }
        if (EntityTypes.GHAST.equals(packetEntity.type)) {
            return 4.0f;
        }
        if (EntityTypes.GIANT.equals(packetEntity.type)) {
            return 3.6f;
        }
        if (EntityTypes.GUARDIAN.equals(packetEntity.type)) {
            return 0.85f;
        }
        if (EntityTypes.IRON_GOLEM.equals(packetEntity.type)) {
            return 1.4f;
        }
        if (EntityTypes.MAGMA_CUBE.equals(packetEntity.type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                return 0.51000005f * (float)((PacketEntitySizeable)packetEntity).size;
            }
            return 0.98f;
        }
        if (EntityTypes.isTypeInstanceOf(packetEntity.type, EntityTypes.MINECART_ABSTRACT)) {
            return 0.98f;
        }
        if (EntityTypes.PLAYER.equals(packetEntity.type)) {
            return 0.6f;
        }
        if (EntityTypes.POLAR_BEAR.equals(packetEntity.type)) {
            return 1.4f;
        }
        if (EntityTypes.RAVAGER.equals(packetEntity.type)) {
            return 1.95f;
        }
        if (EntityTypes.SHULKER.equals(packetEntity.type)) {
            return 1.0f;
        }
        if (EntityTypes.SLIME.equals(packetEntity.type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                return 0.51000005f * (float)((PacketEntitySizeable)packetEntity).size;
            }
            return 0.3125f;
        }
        if (EntityTypes.SMALL_FIREBALL.equals(packetEntity.type)) {
            return 0.3125f;
        }
        if (EntityTypes.SPIDER.equals(packetEntity.type)) {
            return 1.4f;
        }
        if (EntityTypes.SQUID.equals(packetEntity.type)) {
            return 0.8f;
        }
        if (EntityTypes.TURTLE.equals(packetEntity.type)) {
            return 1.2f;
        }
        if (EntityTypes.ALLAY.equals(packetEntity.type)) {
            return 0.35f;
        }
        return 0.6f;
    }

    public static Vector3d getRidingOffsetFromVehicle(PacketEntity entity, GrimPlayer player) {
        SimpleCollisionBox box = entity.getPossibleCollisionBoxes();
        double x = (box.maxX + box.minX) / 2.0;
        double y = box.minY;
        double z = (box.maxZ + box.minZ) / 2.0;
        if (entity instanceof PacketEntityTrackXRot) {
            PacketEntityTrackXRot xRotEntity = (PacketEntityTrackXRot)entity;
            if (EntityTypes.isTypeInstanceOf(entity.type, EntityTypes.BOAT)) {
                float f = 0.0f;
                float f1 = (float)(BoundingBoxSize.getPassengerRidingOffset(player, entity) - (double)0.35f);
                if (!entity.passengers.isEmpty()) {
                    int i = entity.passengers.indexOf(player.compensatedEntities.getSelf());
                    if (i == 0) {
                        f = 0.2f;
                    } else if (i == 1) {
                        f = -0.6f;
                    }
                }
                Vector3d vec3 = new Vector3d(f, 0.0, 0.0);
                vec3 = BoundingBoxSize.yRot(-xRotEntity.interpYaw * ((float)Math.PI / 180) - 1.5707964f, vec3);
                return new Vector3d(x + vec3.x, y + (double)f1, z + vec3.z);
            }
            if (entity.type == EntityTypes.LLAMA) {
                float f = player.trigHandler.cos(xRotEntity.interpYaw * ((float)Math.PI / 180));
                float f1 = player.trigHandler.sin(xRotEntity.interpYaw * ((float)Math.PI / 180));
                return new Vector3d(x + (double)(0.3f * f1), y + BoundingBoxSize.getPassengerRidingOffset(player, entity) - (double)0.35f, z + (double)(0.3f * f));
            }
            if (entity.type == EntityTypes.CHICKEN) {
                float f = player.trigHandler.sin(xRotEntity.interpYaw * ((float)Math.PI / 180));
                float f1 = player.trigHandler.cos(xRotEntity.interpYaw * ((float)Math.PI / 180));
                return new Vector3d(x + (double)(0.1f * f), (y += (double)(BoundingBoxSize.getHeight(player, entity) * 0.5f)) - (double)0.35f, z - (double)(0.1f * f1));
            }
        }
        return new Vector3d(x, y + BoundingBoxSize.getPassengerRidingOffset(player, entity) - (double)0.35f, z);
    }

    private static Vector3d yRot(float p_82525_, Vector3d start) {
        float f = (float)Math.cos(p_82525_);
        float f1 = (float)Math.sin(p_82525_);
        double d0 = start.getX() * (double)f + start.getZ() * (double)f1;
        double d1 = start.getY();
        double d2 = start.getZ() * (double)f - start.getX() * (double)f1;
        return new Vector3d(d0, d1, d2);
    }

    public static float getHeight(GrimPlayer player, PacketEntity packetEntity) {
        if (packetEntity.type == EntityTypes.TURTLE && packetEntity.isBaby) {
            return 0.12f;
        }
        return BoundingBoxSize.getHeightMinusBaby(player, packetEntity) * (packetEntity.isBaby ? 0.5f : 1.0f);
    }

    public static double getMyRidingOffset(PacketEntity packetEntity) {
        if (EntityTypes.PIGLIN.equals(packetEntity.type) || EntityTypes.ZOMBIFIED_PIGLIN.equals(packetEntity.type) || EntityTypes.ZOMBIE.equals(packetEntity.type)) {
            return packetEntity.isBaby ? -0.05 : -0.45;
        }
        if (EntityTypes.SKELETON.equals(packetEntity.type)) {
            return -0.6;
        }
        if (EntityTypes.ENDERMITE.equals(packetEntity.type) || EntityTypes.SILVERFISH.equals(packetEntity.type)) {
            return 0.1;
        }
        if (EntityTypes.EVOKER.equals(packetEntity.type) || EntityTypes.ILLUSIONER.equals(packetEntity.type) || EntityTypes.PILLAGER.equals(packetEntity.type) || EntityTypes.RAVAGER.equals(packetEntity.type) || EntityTypes.VINDICATOR.equals(packetEntity.type) || EntityTypes.WITCH.equals(packetEntity.type)) {
            return -0.45;
        }
        if (EntityTypes.PLAYER.equals(packetEntity.type)) {
            return -0.35;
        }
        if (EntityTypes.isTypeInstanceOf(packetEntity.type, EntityTypes.ABSTRACT_ANIMAL)) {
            return 0.14;
        }
        return 0.0;
    }

    public static double getPassengerRidingOffset(GrimPlayer player, PacketEntity packetEntity) {
        if (packetEntity instanceof PacketEntityHorse) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.75 - 0.25;
        }
        if (EntityTypes.isTypeInstanceOf(packetEntity.type, EntityTypes.MINECART_ABSTRACT)) {
            return 0.0;
        }
        if (EntityTypes.isTypeInstanceOf(packetEntity.type, EntityTypes.BOAT)) {
            return -0.1;
        }
        if (EntityTypes.HOGLIN.equals(packetEntity.type) || EntityTypes.ZOGLIN.equals(packetEntity.type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) - (packetEntity.isBaby ? 0.2 : 0.15);
        }
        if (EntityTypes.LLAMA.equals(packetEntity.type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.67;
        }
        if (EntityTypes.PIGLIN.equals(packetEntity.type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.92;
        }
        if (EntityTypes.RAVAGER.equals(packetEntity.type)) {
            return 2.1;
        }
        if (EntityTypes.SKELETON.equals(packetEntity.type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.75 - 0.1875;
        }
        if (EntityTypes.SPIDER.equals(packetEntity.type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.5;
        }
        if (EntityTypes.STRIDER.equals(packetEntity.type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) - 0.19;
        }
        return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.75;
    }

    private static float getHeightMinusBaby(GrimPlayer player, PacketEntity packetEntity) {
        if (EntityTypes.AXOLOTL.equals(packetEntity.type) || EntityTypes.BEE.equals(packetEntity.type) || EntityTypes.DOLPHIN.equals(packetEntity.type) || EntityTypes.ALLAY.equals(packetEntity.type)) {
            return 0.6f;
        }
        if (EntityTypes.PARROT.equals(packetEntity.type) || EntityTypes.EVOKER_FANGS.equals(packetEntity.type) || EntityTypes.SQUID.equals(packetEntity.type) || EntityTypes.VEX.equals(packetEntity.type)) {
            return 0.8f;
        }
        if (EntityTypes.BAT.equals(packetEntity.type) || EntityTypes.PIG.equals(packetEntity.type) || EntityTypes.SPIDER.equals(packetEntity.type)) {
            return 0.9f;
        }
        if (EntityTypes.WITHER_SKULL.equals(packetEntity.type) || EntityTypes.SHULKER_BULLET.equals(packetEntity.type)) {
            return 0.3125f;
        }
        if (EntityTypes.BLAZE.equals(packetEntity.type)) {
            return 1.8f;
        }
        if (EntityTypes.isTypeInstanceOf(packetEntity.type, EntityTypes.BOAT)) {
            return 0.5625f;
        }
        if (EntityTypes.CAT.equals(packetEntity.type)) {
            return 0.7f;
        }
        if (EntityTypes.CAVE_SPIDER.equals(packetEntity.type)) {
            return 0.5f;
        }
        if (EntityTypes.FROG.equals(packetEntity.type)) {
            return 0.55f;
        }
        if (EntityTypes.CHICKEN.equals(packetEntity.type)) {
            return 0.7f;
        }
        if (EntityTypes.HOGLIN.equals(packetEntity.type) || EntityTypes.ZOGLIN.equals(packetEntity.type)) {
            return 1.4f;
        }
        if (EntityTypes.COW.equals(packetEntity.type)) {
            return 1.4f;
        }
        if (EntityTypes.STRIDER.equals(packetEntity.type)) {
            return 1.7f;
        }
        if (EntityTypes.CREEPER.equals(packetEntity.type)) {
            return 1.7f;
        }
        if (EntityTypes.DONKEY.equals(packetEntity.type)) {
            return 1.5f;
        }
        if (EntityTypes.ELDER_GUARDIAN.equals(packetEntity.type)) {
            return 1.9975f;
        }
        if (EntityTypes.ENDERMAN.equals(packetEntity.type) || EntityTypes.WARDEN.equals(packetEntity.type)) {
            return 2.9f;
        }
        if (EntityTypes.ENDERMITE.equals(packetEntity.type) || EntityTypes.COD.equals(packetEntity.type)) {
            return 0.3f;
        }
        if (EntityTypes.END_CRYSTAL.equals(packetEntity.type)) {
            return 2.0f;
        }
        if (EntityTypes.ENDER_DRAGON.equals(packetEntity.type)) {
            return 8.0f;
        }
        if (EntityTypes.FIREBALL.equals(packetEntity.type)) {
            return 1.0f;
        }
        if (EntityTypes.FOX.equals(packetEntity.type)) {
            return 0.7f;
        }
        if (EntityTypes.GHAST.equals(packetEntity.type)) {
            return 4.0f;
        }
        if (EntityTypes.GIANT.equals(packetEntity.type)) {
            return 12.0f;
        }
        if (EntityTypes.GUARDIAN.equals(packetEntity.type)) {
            return 0.85f;
        }
        if (EntityTypes.HORSE.equals(packetEntity.type)) {
            return 1.6f;
        }
        if (EntityTypes.IRON_GOLEM.equals(packetEntity.type)) {
            return 2.7f;
        }
        if (EntityTypes.LLAMA.equals(packetEntity.type) || EntityTypes.TRADER_LLAMA.equals(packetEntity.type)) {
            return 1.87f;
        }
        if (EntityTypes.TROPICAL_FISH.equals(packetEntity.type)) {
            return 0.4f;
        }
        if (EntityTypes.MAGMA_CUBE.equals(packetEntity.type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                return 0.51000005f * (float)((PacketEntitySizeable)packetEntity).size;
            }
            return 0.7f;
        }
        if (EntityTypes.isTypeInstanceOf(packetEntity.type, EntityTypes.MINECART_ABSTRACT)) {
            return 0.7f;
        }
        if (EntityTypes.MULE.equals(packetEntity.type)) {
            return 1.6f;
        }
        if (EntityTypes.MOOSHROOM.equals(packetEntity.type)) {
            return 1.4f;
        }
        if (EntityTypes.OCELOT.equals(packetEntity.type)) {
            return 0.7f;
        }
        if (EntityTypes.PANDA.equals(packetEntity.type)) {
            return 1.25f;
        }
        if (EntityTypes.PHANTOM.equals(packetEntity.type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                return 0.5f + (float)((PacketEntitySizeable)packetEntity).size * 0.1f;
            }
            return 1.8f;
        }
        if (EntityTypes.PLAYER.equals(packetEntity.type)) {
            return 1.8f;
        }
        if (EntityTypes.POLAR_BEAR.equals(packetEntity.type)) {
            return 1.4f;
        }
        if (EntityTypes.PUFFERFISH.equals(packetEntity.type)) {
            return 0.7f;
        }
        if (EntityTypes.RABBIT.equals(packetEntity.type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 0.5f : 0.7f;
        }
        if (EntityTypes.RAVAGER.equals(packetEntity.type)) {
            return 2.2f;
        }
        if (EntityTypes.SALMON.equals(packetEntity.type)) {
            return 0.4f;
        }
        if (EntityTypes.SHEEP.equals(packetEntity.type) || EntityTypes.GOAT.equals(packetEntity.type)) {
            return 1.3f;
        }
        if (EntityTypes.SHULKER.equals(packetEntity.type)) {
            return 2.0f;
        }
        if (EntityTypes.SILVERFISH.equals(packetEntity.type)) {
            return 0.3f;
        }
        if (EntityTypes.SKELETON.equals(packetEntity.type)) {
            return 1.99f;
        }
        if (EntityTypes.SKELETON_HORSE.equals(packetEntity.type)) {
            return 1.6f;
        }
        if (EntityTypes.SLIME.equals(packetEntity.type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                return 0.51000005f * (float)((PacketEntitySizeable)packetEntity).size;
            }
            return 0.3125f;
        }
        if (EntityTypes.SMALL_FIREBALL.equals(packetEntity.type)) {
            return 0.3125f;
        }
        if (EntityTypes.SNOW_GOLEM.equals(packetEntity.type)) {
            return 1.9f;
        }
        if (EntityTypes.STRAY.equals(packetEntity.type)) {
            return 1.99f;
        }
        if (EntityTypes.TURTLE.equals(packetEntity.type)) {
            return 0.4f;
        }
        if (EntityTypes.WITHER.equals(packetEntity.type)) {
            return 3.5f;
        }
        if (EntityTypes.WITHER_SKELETON.equals(packetEntity.type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 2.4f : 2.535f;
        }
        if (EntityTypes.WOLF.equals(packetEntity.type)) {
            return 0.85f;
        }
        if (EntityTypes.ZOMBIE_HORSE.equals(packetEntity.type)) {
            return 1.6f;
        }
        if (EntityTypes.TADPOLE.equals(packetEntity.type)) {
            return 0.3f;
        }
        return 1.95f;
    }
}

