/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.nmsutil;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.enchantment.type.EnchantmentTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.utils.data.packetentity.PacketEntityHorse;
import ac.grim.grimac.utils.data.packetentity.PacketEntityStrider;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.nmsutil.Materials;

public class BlockProperties {
    public static float getBlockFrictionUnderPlayer(GrimPlayer player) {
        if (player.isGliding || player.isFlying) {
            return 1.0f;
        }
        double searchBelowAmount = 0.5000001;
        if (player.getClientVersion().isOlderThan(ClientVersion.V_1_15)) {
            searchBelowAmount = 1.0;
        }
        StateType material = player.compensatedWorld.getStateTypeAt(player.lastX, player.lastY - searchBelowAmount, player.lastZ);
        return BlockProperties.getMaterialFriction(player, material);
    }

    public static float getMaterialFriction(GrimPlayer player, StateType material) {
        float friction = 0.6f;
        if (material == StateTypes.ICE) {
            friction = 0.98f;
        }
        if (material == StateTypes.SLIME_BLOCK && player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_8)) {
            friction = 0.8f;
        }
        if (material == StateTypes.HONEY_BLOCK && player.getClientVersion().isOlderThan(ClientVersion.V_1_15)) {
            friction = 0.8f;
        }
        if (material == StateTypes.PACKED_ICE) {
            friction = 0.98f;
        }
        if (material == StateTypes.FROSTED_ICE) {
            friction = 0.98f;
        }
        if (material == StateTypes.BLUE_ICE) {
            friction = 0.98f;
            if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_13)) {
                friction = 0.989f;
            }
        }
        return friction;
    }

    public static float getFrictionInfluencedSpeed(float f, GrimPlayer player) {
        if (player.lastOnGround) {
            return (float)(player.speed * (double)(0.21600002f / (f * f * f)));
        }
        if (player.compensatedEntities.getSelf().getRiding() != null) {
            if (player.compensatedEntities.getSelf().getRiding().type == EntityTypes.PIG || player.compensatedEntities.getSelf().getRiding() instanceof PacketEntityHorse) {
                return (float)(player.speed * (double)0.1f);
            }
            if (player.compensatedEntities.getSelf().getRiding() instanceof PacketEntityStrider) {
                PacketEntityStrider strider = (PacketEntityStrider)player.compensatedEntities.getSelf().getRiding();
                return strider.movementSpeedAttribute * (strider.isShaking ? 0.66f : 1.0f) * 0.1f;
            }
        }
        if (player.isFlying) {
            return player.flySpeed * 20.0f * (player.isSprinting ? 0.1f : 0.05f);
        }
        return player.lastSprintingForSpeed ? 0.025999999f : 0.02f;
    }

    public static StateType getOnBlock(GrimPlayer player, double x, double y, double z) {
        StateType block2;
        StateType block1 = player.compensatedWorld.getStateTypeAt(GrimMath.floor(x), GrimMath.floor(y - (double)0.2f), GrimMath.floor(z));
        if (block1.isAir() && (Materials.isFence(block2 = player.compensatedWorld.getStateTypeAt(GrimMath.floor(x), GrimMath.floor(y - (double)1.2f), GrimMath.floor(z))) || Materials.isWall(block2) || Materials.isGate(block2))) {
            return block2;
        }
        return block1;
    }

    public static float getBlockSpeedFactor(GrimPlayer player) {
        StateType onBlock;
        if (player.isGliding || player.isFlying) {
            return 1.0f;
        }
        if (player.getClientVersion().isOlderThan(ClientVersion.V_1_15)) {
            return 1.0f;
        }
        StateType block = player.compensatedWorld.getStateTypeAt(player.x, player.y, player.z);
        if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_16) && player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_16_1) && (onBlock = BlockProperties.getOnBlock(player, player.x, player.y, player.z)) == StateTypes.SOUL_SAND && player.getInventory().getBoots().getEnchantmentLevel(EnchantmentTypes.SOUL_SPEED, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()) > 0) {
            return 1.0f;
        }
        if (block == StateTypes.HONEY_BLOCK) {
            return 0.4f;
        }
        if (block == StateTypes.SOUL_SAND) {
            if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_16_2) && player.getInventory().getBoots().getEnchantmentLevel(EnchantmentTypes.SOUL_SPEED, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()) > 0) {
                return 1.0f;
            }
            return 0.4f;
        }
        float f = 1.0f;
        if (block == StateTypes.WATER || block == StateTypes.BUBBLE_COLUMN) {
            return f;
        }
        StateType block2 = player.compensatedWorld.getStateTypeAt(player.x, player.y - 0.5000001, player.z);
        if (block2 == StateTypes.HONEY_BLOCK) {
            return 0.4f;
        }
        if (block2 == StateTypes.SOUL_SAND) {
            if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_16_2) && player.getInventory().getBoots().getEnchantmentLevel(EnchantmentTypes.SOUL_SPEED, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()) > 0) {
                return 1.0f;
            }
            return 0.4f;
        }
        return 1.0f;
    }
}

