/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.nmsutil;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.enchantment.type.EnchantmentTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.GameMode;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.potion.PotionTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.MaterialType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.defaulttags.BlockTags;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.utils.enums.FluidTag;
import ac.grim.grimac.utils.nmsutil.Materials;

public class BlockBreakSpeed {
    public static double getBlockDamage(GrimPlayer player, Vector3i position) {
        boolean canHarvest;
        Integer miningFatigue;
        int digSpeed;
        ItemStack tool = player.getInventory().getHeldItem();
        WrappedBlockState block = player.compensatedWorld.getWrappedBlockStateAt(position);
        float blockHardness = block.getType().getHardness();
        if (player.gamemode == GameMode.CREATIVE) {
            if (tool.getType().hasAttribute(ItemTypes.ItemAttribute.SWORD)) {
                return 0.0;
            }
            return 1.0;
        }
        if (blockHardness == -1.0f) {
            return 0.0;
        }
        boolean isCorrectToolForDrop = false;
        float speedMultiplier = 1.0f;
        if (tool.getType().hasAttribute(ItemTypes.ItemAttribute.AXE)) {
            isCorrectToolForDrop = BlockTags.MINEABLE_WITH_AXE.contains(block.getType());
        } else if (tool.getType().hasAttribute(ItemTypes.ItemAttribute.PICKAXE)) {
            isCorrectToolForDrop = BlockTags.MINEABLE_WITH_PICKAXE.contains(block.getType());
        } else if (tool.getType().hasAttribute(ItemTypes.ItemAttribute.SHOVEL)) {
            isCorrectToolForDrop = BlockTags.MINEABLE_WITH_SHOVEL.contains(block.getType());
        } else if (tool.getType().hasAttribute(ItemTypes.ItemAttribute.HOE)) {
            isCorrectToolForDrop = BlockTags.MINEABLE_WITH_HOE.contains(block.getType());
        }
        if (isCorrectToolForDrop) {
            int tier = 0;
            if (tool.getType().hasAttribute(ItemTypes.ItemAttribute.WOOD_TIER)) {
                speedMultiplier = 2.0f;
            } else if (tool.getType().hasAttribute(ItemTypes.ItemAttribute.STONE_TIER)) {
                speedMultiplier = 4.0f;
                tier = 1;
            } else if (tool.getType().hasAttribute(ItemTypes.ItemAttribute.IRON_TIER)) {
                speedMultiplier = 6.0f;
                tier = 2;
            } else if (tool.getType().hasAttribute(ItemTypes.ItemAttribute.DIAMOND_TIER)) {
                speedMultiplier = 8.0f;
                tier = 3;
            } else if (tool.getType().hasAttribute(ItemTypes.ItemAttribute.GOLD_TIER)) {
                speedMultiplier = 12.0f;
            } else if (tool.getType().hasAttribute(ItemTypes.ItemAttribute.NETHERITE_TIER)) {
                speedMultiplier = 9.0f;
                tier = 4;
            }
            if (tier < 3 && BlockTags.NEEDS_DIAMOND_TOOL.contains(block.getType())) {
                isCorrectToolForDrop = false;
            } else if (tier < 2 && BlockTags.NEEDS_IRON_TOOL.contains(block.getType())) {
                isCorrectToolForDrop = false;
            } else if (tier < 1 && BlockTags.NEEDS_STONE_TOOL.contains(block.getType())) {
                isCorrectToolForDrop = false;
            }
        }
        if (tool.getType() == ItemTypes.SHEARS) {
            isCorrectToolForDrop = true;
            if (block.getType() == StateTypes.COBWEB || Materials.isLeaves(block.getType())) {
                speedMultiplier = 15.0f;
            } else if (BlockTags.WOOL.contains(block.getType())) {
                speedMultiplier = 5.0f;
            } else if (block.getType() == StateTypes.VINE || block.getType() == StateTypes.GLOW_LICHEN) {
                speedMultiplier = 2.0f;
            } else {
                boolean bl = isCorrectToolForDrop = block.getType() == StateTypes.COBWEB || block.getType() == StateTypes.REDSTONE_WIRE || block.getType() == StateTypes.TRIPWIRE;
            }
        }
        if (tool.getType().hasAttribute(ItemTypes.ItemAttribute.SWORD)) {
            if (block.getType() == StateTypes.COBWEB) {
                speedMultiplier = 15.0f;
            } else if (block.getType().getMaterialType() == MaterialType.PLANT || BlockTags.LEAVES.contains(block.getType()) || block.getType() == StateTypes.PUMPKIN || block.getType() == StateTypes.MELON) {
                speedMultiplier = 1.5f;
            }
            boolean bl = isCorrectToolForDrop = block.getType() == StateTypes.COBWEB;
        }
        if (speedMultiplier > 1.0f && (digSpeed = tool.getEnchantmentLevel(EnchantmentTypes.BLOCK_EFFICIENCY, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion())) > 0) {
            speedMultiplier += (float)(digSpeed * digSpeed + 1);
        }
        Integer digSpeed2 = player.compensatedEntities.getPotionLevelForPlayer(PotionTypes.HASTE);
        Integer conduit = player.compensatedEntities.getPotionLevelForPlayer(PotionTypes.CONDUIT_POWER);
        if (digSpeed2 != null || conduit != null) {
            int hasteLevel = Math.max(digSpeed2 == null ? 0 : digSpeed2, conduit == null ? 0 : conduit);
            speedMultiplier = (float)((double)speedMultiplier * (1.0 + 0.2 * (double)(hasteLevel + 1)));
        }
        if ((miningFatigue = player.compensatedEntities.getPotionLevelForPlayer(PotionTypes.MINING_FATIGUE)) != null) {
            switch (miningFatigue) {
                case 0: {
                    speedMultiplier = (float)((double)speedMultiplier * 0.3);
                    break;
                }
                case 1: {
                    speedMultiplier = (float)((double)speedMultiplier * 0.09);
                    break;
                }
                case 2: {
                    speedMultiplier = (float)((double)speedMultiplier * 0.0027);
                    break;
                }
                default: {
                    speedMultiplier = (float)((double)speedMultiplier * 8.1E-4);
                }
            }
        }
        if (player.fluidOnEyes == FluidTag.WATER) {
            ItemStack helmet = player.getInventory().getHelmet();
            ItemStack chestplate = player.getInventory().getChestplate();
            ItemStack leggings = player.getInventory().getLeggings();
            ItemStack boots = player.getInventory().getBoots();
            if (!(helmet != null && helmet.getEnchantmentLevel(EnchantmentTypes.AQUA_AFFINITY, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()) != 0 || chestplate != null && chestplate.getEnchantmentLevel(EnchantmentTypes.AQUA_AFFINITY, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()) != 0 || leggings != null && leggings.getEnchantmentLevel(EnchantmentTypes.AQUA_AFFINITY, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()) != 0 || boots != null && boots.getEnchantmentLevel(EnchantmentTypes.AQUA_AFFINITY, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()) != 0)) {
                speedMultiplier /= 5.0f;
            }
        }
        if (!player.packetStateData.packetPlayerOnGround) {
            speedMultiplier /= 5.0f;
        }
        float damage = speedMultiplier / blockHardness;
        boolean bl = canHarvest = !block.getType().isRequiresCorrectTool() || isCorrectToolForDrop;
        damage = canHarvest ? (damage /= 30.0f) : (damage /= 100.0f);
        return damage;
    }
}

