/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.math;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.utils.math.LegacyFastMath;
import ac.grim.grimac.utils.math.OptifineFastMath;
import ac.grim.grimac.utils.math.VanillaMath;
import org.bukkit.util.Vector;

public class TrigHandler {
    GrimPlayer player;
    private double buffer = 0.0;
    private boolean isVanillaMath = true;

    public TrigHandler(GrimPlayer player) {
        this.player = player;
    }

    public void toggleShitMath() {
        this.isVanillaMath = !this.isVanillaMath;
    }

    public Vector getVanillaMathMovement(Vector wantedMovement, float f, float f2) {
        float f3 = VanillaMath.sin(f2 * ((float)Math.PI / 180));
        float f4 = VanillaMath.cos(f2 * ((float)Math.PI / 180));
        float bestTheoreticalX = (float)((double)f3 * wantedMovement.getZ() + (double)f4 * wantedMovement.getX()) / (f3 * f3 + f4 * f4) / f;
        float bestTheoreticalZ = (float)((double)(-f3) * wantedMovement.getX() + (double)f4 * wantedMovement.getZ()) / (f3 * f3 + f4 * f4) / f;
        return new Vector(bestTheoreticalX, 0.0f, bestTheoreticalZ);
    }

    public Vector getShitMathMovement(Vector wantedMovement, float f, float f2) {
        float f3 = this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_8) ? OptifineFastMath.sin(f2 * ((float)Math.PI / 180)) : LegacyFastMath.sin(f2 * ((float)Math.PI / 180));
        float f4 = this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_8) ? OptifineFastMath.cos(f2 * ((float)Math.PI / 180)) : LegacyFastMath.cos(f2 * ((float)Math.PI / 180));
        float bestTheoreticalX = (float)((double)f3 * wantedMovement.getZ() + (double)f4 * wantedMovement.getX()) / (f3 * f3 + f4 * f4) / f;
        float bestTheoreticalZ = (float)((double)(-f3) * wantedMovement.getX() + (double)f4 * wantedMovement.getZ()) / (f3 * f3 + f4 * f4) / f;
        return new Vector(bestTheoreticalX, 0.0f, bestTheoreticalZ);
    }

    public void setOffset(double offset) {
        if (offset == 0.0 || offset > 0.001) {
            return;
        }
        if (offset > 1.0E-5) {
            Vector trueMovement = this.player.actualMovement.clone().subtract(this.player.startTickClientVel);
            Vector correctMath = this.getVanillaMathMovement(trueMovement, 0.1f, this.player.xRot);
            Vector fastMath = this.getShitMathMovement(trueMovement, 0.1f, this.player.xRot);
            correctMath = new Vector(Math.abs(correctMath.getX()), 0.0, Math.abs(correctMath.getZ()));
            fastMath = new Vector(Math.abs(fastMath.getX()), 0.0, Math.abs(fastMath.getZ()));
            double minCorrectHorizontal = Math.min(correctMath.getX(), correctMath.getZ());
            minCorrectHorizontal = Math.min(minCorrectHorizontal, Math.abs(correctMath.getX() - correctMath.getZ()));
            double minFastMathHorizontal = Math.min(fastMath.getX(), fastMath.getZ());
            boolean newVanilla = minCorrectHorizontal < (minFastMathHorizontal = Math.min(minFastMathHorizontal, Math.abs(fastMath.getX() - fastMath.getZ())));
            this.buffer += newVanilla != this.isVanillaMath ? 1.0 : -0.25;
            if (this.buffer > 5.0) {
                this.buffer = 0.0;
                this.isVanillaMath = !this.isVanillaMath;
            }
            this.buffer = Math.max(0.0, this.buffer);
        }
    }

    public float sin(float f) {
        return this.isVanillaMath ? VanillaMath.sin(f) : (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_8) ? OptifineFastMath.sin(f) : LegacyFastMath.sin(f));
    }

    public float cos(float f) {
        return this.isVanillaMath ? VanillaMath.cos(f) : (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_8) ? OptifineFastMath.cos(f) : LegacyFastMath.cos(f));
    }

    public boolean isVanillaMath() {
        return this.isVanillaMath;
    }
}

