/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.math;

import java.util.List;

public final class GrimMath {
    public static final double MINIMUM_DIVISOR = Math.pow(0.2f, 3.0) * 8.0 * 0.15 - 0.001;

    public static double gcd(double a, double b) {
        double temp;
        if (a == 0.0) {
            return 0.0;
        }
        if (a < b) {
            temp = a;
            a = b;
            b = temp;
        }
        while (b > MINIMUM_DIVISOR) {
            temp = a - Math.floor(a / b) * b;
            a = b;
            b = temp;
        }
        return a;
    }

    public static double calculateSD(List<Double> numbers) {
        double sum = 0.0;
        double standardDeviation = 0.0;
        for (double rotation : numbers) {
            sum += rotation;
        }
        double mean = sum / (double)numbers.size();
        for (double num : numbers) {
            standardDeviation += Math.pow(num - mean, 2.0);
        }
        return Math.sqrt(standardDeviation / (double)numbers.size());
    }

    public static int floor(double d) {
        return (int)Math.floor(d);
    }

    public static int ceil(double d) {
        return (int)Math.ceil(d);
    }

    public static double clamp(double d, double d2, double d3) {
        if (d < d2) {
            return d2;
        }
        return Math.min(d, d3);
    }

    public static float clampFloat(float d, float d2, float d3) {
        if (d < d2) {
            return d2;
        }
        return Math.min(d, d3);
    }

    public static double lerp(double lerpAmount, double start, double end) {
        return start + lerpAmount * (end - start);
    }

    public static double frac(double p_14186_) {
        return p_14186_ - (double)GrimMath.lfloor(p_14186_);
    }

    public static long lfloor(double p_14135_) {
        long i = (long)p_14135_;
        return p_14135_ < (double)i ? i - 1L : i;
    }

    public static double distanceToHorizontalCollision(double position) {
        return Math.min(Math.abs(position % 0.0015625), Math.abs(Math.abs(position % 0.0015625) - 0.0015625));
    }

    public static boolean betweenRange(double value, double min, double max) {
        return value > min && value < max;
    }

    public static boolean inRange(double value, double min, double max) {
        return value >= min && value <= max;
    }

    public static boolean isNearlySame(double a, double b, double epoch) {
        return Math.abs(a - b) < epoch;
    }

    private GrimMath() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

