/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.lists;

import ac.grim.grimac.utils.data.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public class RunningMode {
    Queue<Double> addList;
    Map<Double, Integer> popularityMap = new HashMap<Double, Integer>();
    int maxSize;
    private static final double threshold = 0.001;

    public RunningMode(int maxSize) {
        if (maxSize == 0) {
            throw new IllegalArgumentException("There's no mode to a size 0 list!");
        }
        this.addList = new ArrayBlockingQueue<Double>(maxSize);
        this.maxSize = maxSize;
    }

    public int size() {
        return this.addList.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void add(double value) {
        this.pop();
        for (Map.Entry<Double, Integer> entry : this.popularityMap.entrySet()) {
            if (!(Math.abs(entry.getKey() - value) < 0.001)) continue;
            entry.setValue(entry.getValue() + 1);
            this.addList.add(entry.getKey());
            return;
        }
        this.popularityMap.put(value, 1);
        this.addList.add(value);
    }

    private void pop() {
        if (this.addList.size() >= this.maxSize) {
            Double type = this.addList.poll();
            int popularity = this.popularityMap.get(type);
            if (popularity == 1) {
                this.popularityMap.remove(type);
            } else {
                this.popularityMap.put(type, popularity - 1);
            }
        }
    }

    public Pair<Double, Integer> getMode() {
        int max = 0;
        Double mostPopular = null;
        for (Map.Entry<Double, Integer> entry : this.popularityMap.entrySet()) {
            if (entry.getValue() <= max) continue;
            max = entry.getValue();
            mostPopular = entry.getKey();
        }
        return new Pair<Object, Integer>(mostPopular, max);
    }
}

