/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.latency;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.manager.init.start.ViaBackwardsManager;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.DiggingAction;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.User;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.chunk.BaseChunk;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.chunk.impl.v1_16.Chunk_v1_9;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.chunk.impl.v_1_18.Chunk_v1_18;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.chunk.palette.DataPalette;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.chunk.palette.ListPalette;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.chunk.palette.PaletteType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.chunk.storage.LegacyFlexibleStorage;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.defaulttags.BlockTags;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.enums.East;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.enums.Half;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.enums.North;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.enums.South;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.enums.West;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateValue;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerBlockPlacement;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientUseItem;
import ac.grim.grimac.shaded.fastutil.longs.Long2ObjectOpenHashMap;
import ac.grim.grimac.shaded.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import ac.grim.grimac.utils.chunks.Column;
import ac.grim.grimac.utils.collisions.CollisionData;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.BlockPrediction;
import ac.grim.grimac.utils.data.Pair;
import ac.grim.grimac.utils.data.PistonData;
import ac.grim.grimac.utils.data.ShulkerData;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.data.packetentity.PacketEntityShulker;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.nmsutil.Collisions;
import ac.grim.grimac.utils.nmsutil.GetBoundingBox;
import ac.grim.grimac.utils.nmsutil.Materials;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class CompensatedWorld {
    public static final ClientVersion blockVersion = PacketEvents.getAPI().getServerManager().getVersion().toClientVersion();
    private static final WrappedBlockState airData = WrappedBlockState.getByGlobalId(blockVersion, 0);
    public final GrimPlayer player;
    public final Map<Long, Column> chunks;
    public Set<PistonData> activePistons = new HashSet<PistonData>();
    public Set<ShulkerData> openShulkerBoxes = new HashSet<ShulkerData>();
    private int minHeight = 0;
    private int maxHeight = 256;
    private final Long2ObjectOpenHashMap<BlockPrediction> originalServerBlocks = new Long2ObjectOpenHashMap();
    private List<Vector3i> currentlyChangedBlocks = new LinkedList<Vector3i>();
    private final Map<Integer, List<Vector3i>> serverIsCurrentlyProcessingThesePredictions = new HashMap<Integer, List<Vector3i>>();
    private final Object2ObjectLinkedOpenHashMap<Pair<Vector3i, DiggingAction>, Vector3d> unackedActions = new Object2ObjectLinkedOpenHashMap();
    private boolean isCurrentlyPredicting = false;
    public boolean isRaining = false;
    private boolean noNegativeBlocks;

    public CompensatedWorld(GrimPlayer player) {
        this.player = player;
        this.chunks = new Long2ObjectOpenHashMap<Column>(81, 0.5f);
        this.noNegativeBlocks = player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_16_4);
    }

    public void startPredicting() {
        if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_18_2)) {
            return;
        }
        this.isCurrentlyPredicting = true;
    }

    public void handlePredictionConfirmation(int prediction) {
        Map.Entry<Integer, List<Vector3i>> iter;
        Iterator<Map.Entry<Integer, List<Vector3i>>> it = this.serverIsCurrentlyProcessingThesePredictions.entrySet().iterator();
        while (it.hasNext() && (iter = it.next()).getKey() <= prediction) {
            this.applyBlockChanges(iter.getValue());
            it.remove();
        }
    }

    public void handleBlockBreakAck(Vector3i blockPos, int blockState, DiggingAction action, boolean accepted) {
        if (!accepted || action != DiggingAction.START_DIGGING || !this.unackedActions.containsKey(new Pair<Vector3i, DiggingAction>(blockPos, action))) {
            this.player.sendTransaction();
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                Vector3d playerPos = this.unackedActions.remove(new Pair<Vector3i, DiggingAction>(blockPos, action));
                this.handleAck(blockPos, blockState, playerPos);
            });
        } else {
            this.unackedActions.remove(new Pair<Vector3i, DiggingAction>(blockPos, action));
        }
        this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
            while (this.unackedActions.size() >= 50) {
                this.unackedActions.removeFirst();
            }
        });
    }

    private void applyBlockChanges(List<Vector3i> toApplyBlocks) {
        this.player.sendTransaction();
        this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> toApplyBlocks.forEach(vector3i -> {
            BlockPrediction predictionData = this.originalServerBlocks.get(vector3i.getSerializedPosition());
            if (predictionData != null && predictionData.getForBlockUpdate() == toApplyBlocks) {
                this.originalServerBlocks.remove(vector3i.getSerializedPosition());
                this.handleAck((Vector3i)vector3i, predictionData.getOriginalBlockId(), predictionData.getPlayerPosition());
            }
        }));
    }

    private void handleAck(Vector3i vector3i, int originalBlockId, Vector3d playerPosition) {
        if (this.getWrappedBlockStateAt(vector3i).getGlobalId() != originalBlockId) {
            this.updateBlock(vector3i.getX(), vector3i.getY(), vector3i.getZ(), originalBlockId);
            WrappedBlockState state = WrappedBlockState.getByGlobalId(blockVersion, originalBlockId);
            if (playerPosition != null && CollisionData.getData(state.getType()).getMovementCollisionBox(this.player, this.player.getClientVersion(), state, vector3i.getX(), vector3i.getY(), vector3i.getZ()).isIntersected(this.player.boundingBox)) {
                this.player.lastX = this.player.x;
                this.player.lastY = this.player.y;
                this.player.lastZ = this.player.z;
                this.player.x = playerPosition.getX();
                this.player.y = playerPosition.getY();
                this.player.z = playerPosition.getZ();
                this.player.boundingBox = GetBoundingBox.getCollisionBoxForPlayer(this.player, this.player.x, this.player.y, this.player.z);
            }
        }
    }

    public void handleBlockBreakPrediction(WrapperPlayClientPlayerDigging digging) {
        if (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14_4) && this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_18_2)) {
            this.unackedActions.put(new Pair<Vector3i, DiggingAction>(digging.getBlockPosition(), digging.getAction()), new Vector3d(this.player.x, this.player.y, this.player.z));
        }
    }

    public void stopPredicting(PacketWrapper<?> wrapper) {
        if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_18_2)) {
            return;
        }
        this.isCurrentlyPredicting = false;
        if (this.currentlyChangedBlocks.isEmpty()) {
            return;
        }
        List<Vector3i> toApplyBlocks = this.currentlyChangedBlocks;
        this.currentlyChangedBlocks = new LinkedList<Vector3i>();
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_19)) {
            int confirmationId = 0;
            if (wrapper instanceof WrapperPlayClientPlayerBlockPlacement) {
                confirmationId = ((WrapperPlayClientPlayerBlockPlacement)wrapper).getSequence();
            } else if (wrapper instanceof WrapperPlayClientUseItem) {
                confirmationId = ((WrapperPlayClientUseItem)wrapper).getSequence();
            } else if (wrapper instanceof WrapperPlayClientPlayerDigging) {
                confirmationId = ((WrapperPlayClientPlayerDigging)wrapper).getSequence();
            }
            this.serverIsCurrentlyProcessingThesePredictions.put(confirmationId, toApplyBlocks);
        } else if (!ViaBackwardsManager.didViaBreakBlockPredictions) {
            Bukkit.getScheduler().runTask((Plugin)GrimAPI.INSTANCE.getPlugin(), () -> ChannelHelper.runInEventLoop(this.player.user.getChannel(), () -> this.applyBlockChanges(toApplyBlocks)));
        } else {
            this.applyBlockChanges(toApplyBlocks);
        }
    }

    public static long chunkPositionToLong(int x, int z) {
        return ((long)x & 0xFFFFFFFFL) << 32 | (long)z & 0xFFFFFFFFL;
    }

    public boolean isNearHardEntity(SimpleCollisionBox playerBox) {
        for (PacketEntity packetEntity : this.player.compensatedEntities.entityMap.values()) {
            SimpleCollisionBox box;
            if (!EntityTypes.isTypeInstanceOf(packetEntity.type, EntityTypes.BOAT) && packetEntity.type != EntityTypes.SHULKER || this.player.compensatedEntities.getSelf().getRiding() == packetEntity || !(box = packetEntity.getPossibleCollisionBoxes()).isIntersected(playerBox)) continue;
            return true;
        }
        for (ShulkerData shulkerData : this.openShulkerBoxes) {
            SimpleCollisionBox shulkerCollision = shulkerData.getCollision();
            if (!playerBox.isCollided(shulkerCollision)) continue;
            return true;
        }
        for (PistonData pistonData : this.activePistons) {
            for (SimpleCollisionBox box : pistonData.boxes) {
                if (!playerBox.isCollided(box)) continue;
                return true;
            }
        }
        return false;
    }

    private static BaseChunk create() {
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_18)) {
            return new Chunk_v1_18();
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_16)) {
            return new Chunk_v1_9(0, DataPalette.createForChunk());
        }
        return new Chunk_v1_9(0, new DataPalette(new ListPalette(4), new LegacyFlexibleStorage(4, 4096), PaletteType.CHUNK));
    }

    public void updateBlock(Vector3i pos, WrappedBlockState state) {
        this.updateBlock(pos.getX(), pos.getY(), pos.getZ(), state.getGlobalId());
    }

    public void updateBlock(int x, int y, int z, int combinedID) {
        Vector3i asVector = new Vector3i(x, y, z);
        BlockPrediction prediction = this.originalServerBlocks.get(asVector.getSerializedPosition());
        if (this.isCurrentlyPredicting) {
            if (prediction == null) {
                this.originalServerBlocks.put(asVector.getSerializedPosition(), new BlockPrediction(this.currentlyChangedBlocks, asVector, this.getWrappedBlockStateAt(asVector).getGlobalId(), new Vector3d(this.player.x, this.player.y, this.player.z)));
            } else {
                prediction.setForBlockUpdate(this.currentlyChangedBlocks);
            }
            this.currentlyChangedBlocks.add(asVector);
        }
        if (!this.isCurrentlyPredicting && prediction != null) {
            prediction.setOriginalBlockId(combinedID);
            return;
        }
        Column column = this.getChunk(x >> 4, z >> 4);
        int offsetY = y - this.minHeight;
        if (column != null) {
            if (column.getChunks().length <= offsetY >> 4) {
                return;
            }
            BaseChunk chunk = column.getChunks()[offsetY >> 4];
            if (chunk == null) {
                column.getChunks()[offsetY >> 4] = chunk = CompensatedWorld.create();
                chunk.set(null, 0, 0, 0, 0);
            }
            this.player.pointThreeEstimator.handleChangeBlock(x, y, z, chunk.get(blockVersion, x & 0xF, offsetY & 0xF, z & 0xF));
            chunk.set(null, x & 0xF, offsetY & 0xF, z & 0xF, combinedID);
            this.player.pointThreeEstimator.handleChangeBlock(x, y, z, WrappedBlockState.getByGlobalId(blockVersion, combinedID));
        }
    }

    public void tickOpenable(int blockX, int blockY, int blockZ) {
        WrappedBlockState data = this.player.compensatedWorld.getWrappedBlockStateAt(blockX, blockY, blockZ);
        if (BlockTags.WOODEN_DOORS.contains(data.getType()) || this.player.getClientVersion().isOlderThan(ClientVersion.V_1_8) && data.getType() == StateTypes.IRON_DOOR) {
            WrappedBlockState otherDoor = this.player.compensatedWorld.getWrappedBlockStateAt(blockX, blockY + (data.getHalf() == Half.LOWER ? 1 : -1), blockZ);
            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_13)) {
                if (BlockTags.DOORS.contains(otherDoor.getType())) {
                    otherDoor.setOpen(!otherDoor.isOpen());
                    this.player.compensatedWorld.updateBlock(blockX, blockY + (data.getHalf() == Half.LOWER ? 1 : -1), blockZ, otherDoor.getGlobalId());
                }
                data.setOpen(!data.isOpen());
                this.player.compensatedWorld.updateBlock(blockX, blockY, blockZ, data.getGlobalId());
            } else if (data.getHalf() == Half.LOWER) {
                data.setOpen(!data.isOpen());
                this.player.compensatedWorld.updateBlock(blockX, blockY, blockZ, data.getGlobalId());
            } else if (BlockTags.DOORS.contains(otherDoor.getType()) && otherDoor.getHalf() == Half.LOWER) {
                otherDoor.setOpen(!otherDoor.isOpen());
                this.player.compensatedWorld.updateBlock(blockX, blockY - 1, blockZ, otherDoor.getGlobalId());
            }
        } else if (BlockTags.WOODEN_TRAPDOORS.contains(data.getType()) || BlockTags.FENCE_GATES.contains(data.getType()) || this.player.getClientVersion().isOlderThan(ClientVersion.V_1_8) && data.getType() == StateTypes.IRON_TRAPDOOR) {
            data.setOpen(!data.isOpen());
            this.player.compensatedWorld.updateBlock(blockX, blockY, blockZ, data.getGlobalId());
        } else if (BlockTags.BUTTONS.contains(data.getType())) {
            data.setPowered(true);
        }
    }

    public void tickPlayerInPistonPushingArea() {
        this.player.uncertaintyHandler.tick();
        if (this.player.boundingBox == null) {
            return;
        }
        SimpleCollisionBox expandedBB = GetBoundingBox.getBoundingBoxFromPosAndSize(this.player.lastX, this.player.lastY, this.player.lastZ, 0.001f, 0.001f);
        expandedBB.expandToAbsoluteCoordinates(this.player.x, this.player.y, this.player.z);
        SimpleCollisionBox playerBox = expandedBB.copy().expand(1.0);
        double modX = 0.0;
        double modY = 0.0;
        double modZ = 0.0;
        block0: for (PistonData pistonData : this.activePistons) {
            for (SimpleCollisionBox box2 : pistonData.boxes) {
                if (!playerBox.isCollided(box2)) continue;
                modX = Math.max(modX, Math.abs((double)pistonData.direction.getModX() * 0.51));
                modY = Math.max(modY, Math.abs((double)pistonData.direction.getModY() * 0.51));
                modZ = Math.max(modZ, Math.abs((double)pistonData.direction.getModZ() * 0.51));
                playerBox.expandMax(modX, modY, modZ);
                playerBox.expandMin(modX * -1.0, modY * -1.0, modZ * -1.0);
                if (!pistonData.hasSlimeBlock && (!pistonData.hasHoneyBlock || !this.player.getClientVersion().isOlderThan(ClientVersion.V_1_15_2))) continue block0;
                this.player.uncertaintyHandler.slimePistonBounces.add(pistonData.direction);
                continue block0;
            }
        }
        for (ShulkerData shulkerData : this.openShulkerBoxes) {
            BlockFace direction;
            SimpleCollisionBox shulkerCollision = shulkerData.getCollision();
            if (shulkerData.entity == null) {
                WrappedBlockState state = this.player.compensatedWorld.getWrappedBlockStateAt(shulkerData.blockPos.getX(), shulkerData.blockPos.getY(), shulkerData.blockPos.getZ());
                direction = state.getFacing();
            } else {
                direction = ((PacketEntityShulker)shulkerData.entity).facing.getOppositeFace();
            }
            if (direction == null) {
                direction = BlockFace.UP;
            }
            if (direction.getModX() == -1 || direction.getModY() == -1 || direction.getModZ() == -1) {
                shulkerCollision.expandMin(direction.getModX(), direction.getModY(), direction.getModZ());
            } else {
                shulkerCollision.expandMax(direction.getModZ(), direction.getModY(), direction.getModZ());
            }
            if (!playerBox.isCollided(shulkerCollision)) continue;
            modX = Math.max(modX, Math.abs((double)direction.getModX() * 0.51));
            modY = Math.max(modY, Math.abs((double)direction.getModY() * 0.51));
            modZ = Math.max(modZ, Math.abs((double)direction.getModZ() * 0.51));
            playerBox.expandMax(modX, modY, modZ);
            playerBox.expandMin(modX, modY, modZ);
            this.player.uncertaintyHandler.isSteppingNearShulker = true;
        }
        this.player.uncertaintyHandler.pistonX.add(modX);
        this.player.uncertaintyHandler.pistonY.add(modY);
        this.player.uncertaintyHandler.pistonZ.add(modZ);
        this.activePistons.removeIf(PistonData::tickIfGuaranteedFinished);
        this.openShulkerBoxes.removeIf(ShulkerData::tickIfGuaranteedFinished);
        this.openShulkerBoxes.removeIf(box -> {
            if (box.blockPos != null) {
                return !Materials.isShulker(this.player.compensatedWorld.getWrappedBlockStateAt(box.blockPos).getType());
            }
            return !this.player.compensatedEntities.entityMap.containsValue(box.entity);
        });
    }

    public WrappedBlockState getWrappedBlockStateAt(Vector3i vector3i) {
        return this.getWrappedBlockStateAt(vector3i.getX(), vector3i.getY(), vector3i.getZ());
    }

    public WrappedBlockState getWrappedBlockStateAt(int x, int y, int z) {
        if (this.noNegativeBlocks && y < 0) {
            return airData;
        }
        try {
            Column column = this.getChunk(x >> 4, z >> 4);
            if (column == null || (y -= this.minHeight) < 0 || y >> 4 >= column.getChunks().length) {
                return airData;
            }
            BaseChunk chunk = column.getChunks()[y >> 4];
            if (chunk != null) {
                return chunk.get(blockVersion, x & 0xF, y & 0xF, z & 0xF);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return airData;
    }

    public int getRawPowerAtState(BlockFace face, int x, int y, int z) {
        WrappedBlockState state = this.getWrappedBlockStateAt(x, y, z);
        if (state.getType() == StateTypes.REDSTONE_BLOCK) {
            return 15;
        }
        if (state.getType() == StateTypes.DETECTOR_RAIL) {
            return state.isPowered() ? 15 : 0;
        }
        if (state.getType() == StateTypes.REDSTONE_TORCH) {
            return face != BlockFace.UP && state.isLit() ? 15 : 0;
        }
        if (state.getType() == StateTypes.REDSTONE_WIRE) {
            BlockFace needed = face.getOppositeFace();
            BlockFace badOne = needed.getCW();
            BlockFace badTwo = needed.getCCW();
            boolean isPowered = false;
            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_13)) {
                switch (needed) {
                    case DOWN: {
                        isPowered = true;
                        break;
                    }
                    case UP: {
                        isPowered = state.isUp();
                        break;
                    }
                    case NORTH: {
                        boolean bl = isPowered = state.getNorth() == North.TRUE;
                        if (!isPowered || badOne != BlockFace.NORTH && badTwo != BlockFace.NORTH) break;
                        return 0;
                    }
                    case SOUTH: {
                        boolean bl = isPowered = state.getSouth() == South.TRUE;
                        if (!isPowered || badOne != BlockFace.SOUTH && badTwo != BlockFace.SOUTH) break;
                        return 0;
                    }
                    case WEST: {
                        boolean bl = isPowered = state.getWest() == West.TRUE;
                        if (!isPowered || badOne != BlockFace.WEST && badTwo != BlockFace.WEST) break;
                        return 0;
                    }
                    case EAST: {
                        boolean bl = isPowered = state.getEast() == East.TRUE;
                        if (!isPowered || badOne != BlockFace.EAST && badTwo != BlockFace.EAST) break;
                        return 0;
                    }
                }
            } else {
                isPowered = true;
            }
            return isPowered ? state.getPower() : 0;
        }
        if (state.getType() == StateTypes.REDSTONE_WALL_TORCH) {
            return state.getFacing() != face && state.isPowered() ? 15 : 0;
        }
        if (state.getType() == StateTypes.DAYLIGHT_DETECTOR) {
            return state.getPower();
        }
        if (state.getType() == StateTypes.OBSERVER) {
            return state.getFacing() == face && state.isPowered() ? 15 : 0;
        }
        if (state.getType() == StateTypes.REPEATER) {
            return state.getFacing() == face && state.isPowered() ? state.getPower() : 0;
        }
        if (state.getType() == StateTypes.LECTERN) {
            return state.isPowered() ? 15 : 0;
        }
        if (state.getType() == StateTypes.TARGET) {
            return state.getPower();
        }
        return 0;
    }

    public int getDirectSignalAtState(BlockFace face, int x, int y, int z) {
        WrappedBlockState state = this.getWrappedBlockStateAt(x, y, z);
        if (state.getType() == StateTypes.DETECTOR_RAIL) {
            boolean isPowered = (Boolean)state.getInternalData().getOrDefault((Object)StateValue.POWERED, false);
            return face == BlockFace.UP && isPowered ? 15 : 0;
        }
        if (state.getType() == StateTypes.REDSTONE_TORCH) {
            return face != BlockFace.UP && state.isLit() ? 15 : 0;
        }
        if (state.getType() == StateTypes.LEVER || BlockTags.BUTTONS.contains(state.getType())) {
            return state.getFacing().getOppositeFace() == face && state.isPowered() ? 15 : 0;
        }
        if (state.getType() == StateTypes.REDSTONE_WALL_TORCH) {
            return face == BlockFace.DOWN && state.isPowered() ? 15 : 0;
        }
        if (state.getType() == StateTypes.LECTERN) {
            return face == BlockFace.UP && state.isPowered() ? 15 : 0;
        }
        if (state.getType() == StateTypes.OBSERVER) {
            return state.getFacing() == face && state.isPowered() ? 15 : 0;
        }
        if (state.getType() == StateTypes.REPEATER) {
            return state.getFacing() == face && state.isPowered() ? state.getPower() : 0;
        }
        if (state.getType() == StateTypes.REDSTONE_WIRE) {
            BlockFace needed = face.getOppositeFace();
            BlockFace badOne = needed.getCW();
            BlockFace badTwo = needed.getCCW();
            boolean isPowered = false;
            switch (needed) {
                case DOWN: 
                case UP: {
                    break;
                }
                case NORTH: {
                    boolean bl = isPowered = state.getNorth() == North.TRUE;
                    if (!isPowered || badOne != BlockFace.NORTH && badTwo != BlockFace.NORTH) break;
                    return 0;
                }
                case SOUTH: {
                    boolean bl = isPowered = state.getSouth() == South.TRUE;
                    if (!isPowered || badOne != BlockFace.SOUTH && badTwo != BlockFace.SOUTH) break;
                    return 0;
                }
                case WEST: {
                    boolean bl = isPowered = state.getWest() == West.TRUE;
                    if (!isPowered || badOne != BlockFace.WEST && badTwo != BlockFace.WEST) break;
                    return 0;
                }
                case EAST: {
                    boolean bl = isPowered = state.getEast() == East.TRUE;
                    if (!isPowered || badOne != BlockFace.EAST && badTwo != BlockFace.EAST) break;
                    return 0;
                }
            }
            return isPowered ? state.getPower() : 0;
        }
        return 0;
    }

    public Column getChunk(int chunkX, int chunkZ) {
        long chunkPosition = CompensatedWorld.chunkPositionToLong(chunkX, chunkZ);
        return this.chunks.get(chunkPosition);
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        long chunkPosition = CompensatedWorld.chunkPositionToLong(chunkX, chunkZ);
        return this.chunks.containsKey(chunkPosition);
    }

    public void addToCache(Column chunk, int chunkX, int chunkZ) {
        long chunkPosition = CompensatedWorld.chunkPositionToLong(chunkX, chunkZ);
        this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get() + 1, () -> this.chunks.put(chunkPosition, chunk));
    }

    public StateType getStateTypeAt(double x, double y, double z) {
        return this.getWrappedBlockStateAt((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z)).getType();
    }

    public WrappedBlockState getWrappedBlockStateAt(double x, double y, double z) {
        return this.getWrappedBlockStateAt((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
    }

    public double getFluidLevelAt(int x, int y, int z) {
        return Math.max(this.getWaterFluidLevelAt(x, y, z), this.getLavaFluidLevelAt(x, y, z));
    }

    public boolean isWaterSourceBlock(int x, int y, int z) {
        WrappedBlockState bukkitBlock = this.getWrappedBlockStateAt(x, y, z);
        return Materials.isWaterSource(this.player.getClientVersion(), bukkitBlock);
    }

    public boolean containsLiquid(SimpleCollisionBox var0) {
        return Collisions.hasMaterial(this.player, var0, data -> Materials.isWater(this.player.getClientVersion(), (WrappedBlockState)data.getFirst()) || ((WrappedBlockState)data.getFirst()).getType() == StateTypes.LAVA);
    }

    public double getLavaFluidLevelAt(int x, int y, int z) {
        WrappedBlockState magicBlockState = this.getWrappedBlockStateAt(x, y, z);
        WrappedBlockState magicBlockStateAbove = this.getWrappedBlockStateAt(x, y + 1, z);
        if (magicBlockState.getType() != StateTypes.LAVA) {
            return 0.0;
        }
        if (magicBlockStateAbove.getType() == StateTypes.LAVA) {
            return 1.0;
        }
        int level = magicBlockState.getLevel();
        if (level >= 8) {
            return 0.8888888955116272;
        }
        return (float)(8 - level) / 9.0f;
    }

    public boolean containsLava(SimpleCollisionBox var0) {
        return Collisions.hasMaterial(this.player, var0, data -> ((WrappedBlockState)data.getFirst()).getType() == StateTypes.LAVA);
    }

    public double getWaterFluidLevelAt(double x, double y, double z) {
        return this.getWaterFluidLevelAt(GrimMath.floor(x), GrimMath.floor(y), GrimMath.floor(z));
    }

    public double getWaterFluidLevelAt(int x, int y, int z) {
        WrappedBlockState wrappedBlock = this.getWrappedBlockStateAt(x, y, z);
        boolean isWater = Materials.isWater(this.player.getClientVersion(), wrappedBlock);
        if (!isWater) {
            return 0.0;
        }
        if (Materials.isWater(this.player.getClientVersion(), this.getWrappedBlockStateAt(x, y + 1, z))) {
            return 1.0;
        }
        if (wrappedBlock.getType() == StateTypes.WATER) {
            int level = wrappedBlock.getLevel();
            if ((level & 8) == 8) {
                return 0.8888888955116272;
            }
            return (float)(8 - level) / 9.0f;
        }
        return 0.8888888955116272;
    }

    public void removeChunkLater(int chunkX, int chunkZ) {
        long chunkPosition = CompensatedWorld.chunkPositionToLong(chunkX, chunkZ);
        this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get() + 1, () -> this.player.compensatedWorld.chunks.remove(chunkPosition));
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setDimension(String dimension, User user) {
        if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_17)) {
            return;
        }
        NBTCompound dimensionNBT = user.getWorldNBT(dimension).getCompoundTagOrNull("element");
        this.minHeight = dimensionNBT.getNumberTagOrThrow("min_y").getAsInt();
        this.maxHeight = this.minHeight + dimensionNBT.getNumberTagOrThrow("height").getAsInt();
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public WrappedBlockState getWrappedBlockStateAt(Vector aboveCCWPos) {
        return this.getWrappedBlockStateAt(aboveCCWPos.getX(), aboveCCWPos.getY(), aboveCCWPos.getZ());
    }
}

