/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.latency;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.DiggingAction;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.GameMode;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientClickWindow;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientHeldItemChange;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerOpenHorseWindow;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerOpenWindow;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetSlot;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWindowItems;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.SpigotConversionUtil;
import ac.grim.grimac.utils.anticheat.update.BlockPlace;
import ac.grim.grimac.utils.inventory.Inventory;
import ac.grim.grimac.utils.inventory.InventoryStorage;
import ac.grim.grimac.utils.inventory.inventory.AbstractContainerMenu;
import ac.grim.grimac.utils.inventory.inventory.HorseMenu;
import ac.grim.grimac.utils.inventory.inventory.MenuTypes;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CompensatedInventory
extends Check
implements PacketCheck {
    public Inventory inventory;
    public AbstractContainerMenu menu;
    public boolean isPacketInventoryActive = true;
    public boolean needResend = false;
    int openWindowID = 0;
    public int stateID = 0;

    public CompensatedInventory(GrimPlayer playerData) {
        super(playerData);
        InventoryStorage storage = new InventoryStorage(46);
        this.inventory = new Inventory(playerData, storage);
        this.menu = this.inventory;
    }

    public ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack getHeldItem() {
        ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack item = this.isPacketInventoryActive || this.player.bukkitPlayer == null ? this.inventory.getHeldItem() : SpigotConversionUtil.fromBukkitItemStack(this.player.bukkitPlayer.getInventory().getItemInHand());
        return item == null ? ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY : item;
    }

    public ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack getOffHand() {
        if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_9)) {
            return ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY;
        }
        ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack item = this.isPacketInventoryActive || this.player.bukkitPlayer == null ? this.inventory.getOffhand() : SpigotConversionUtil.fromBukkitItemStack(this.player.bukkitPlayer.getInventory().getItemInOffHand());
        return item == null ? ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY : item;
    }

    public ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack getHelmet() {
        ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack item = this.player.bukkitPlayer == null ? this.inventory.getHelmet() : SpigotConversionUtil.fromBukkitItemStack(this.player.bukkitPlayer.getInventory().getHelmet());
        return item == null ? ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY : item;
    }

    public ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack getChestplate() {
        ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack item = this.player.bukkitPlayer == null ? this.inventory.getChestplate() : SpigotConversionUtil.fromBukkitItemStack(this.player.bukkitPlayer.getInventory().getChestplate());
        return item == null ? ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY : item;
    }

    public ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack getLeggings() {
        ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack item = this.player.bukkitPlayer == null ? this.inventory.getLeggings() : SpigotConversionUtil.fromBukkitItemStack(this.player.bukkitPlayer.getInventory().getLeggings());
        return item == null ? ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY : item;
    }

    public ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack getBoots() {
        ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack item = this.player.bukkitPlayer == null ? this.inventory.getBoots() : SpigotConversionUtil.fromBukkitItemStack(this.player.bukkitPlayer.getInventory().getBoots());
        return item == null ? ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY : item;
    }

    public boolean hasItemType(ItemType type) {
        if (this.isPacketInventoryActive || this.player.bukkitPlayer == null) {
            return this.inventory.hasItemType(type);
        }
        for (ItemStack item : this.player.bukkitPlayer.getInventory().getContents()) {
            ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack itemStack = SpigotConversionUtil.fromBukkitItemStack(item);
            if (itemStack == null || itemStack.getType() != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_DIGGING) {
            WrapperPlayClientPlayerDigging dig = new WrapperPlayClientPlayerDigging(event);
            if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_8)) {
                return;
            }
            if (dig.getAction() == DiggingAction.DROP_ITEM) {
                ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack heldItem = this.getHeldItem();
                if (heldItem != null) {
                    heldItem.setAmount(heldItem.getAmount() - 1);
                    if (heldItem.getAmount() <= 0) {
                        heldItem = null;
                    }
                }
                this.inventory.setHeldItem(heldItem);
            }
            if (dig.getAction() == DiggingAction.DROP_ITEM_STACK) {
                this.inventory.setHeldItem(null);
            }
        }
        if (event.getPacketType() == PacketType.Play.Client.HELD_ITEM_CHANGE) {
            WrapperPlayClientHeldItemChange slot = new WrapperPlayClientHeldItemChange(event);
            if (slot.getSlot() > 8) {
                return;
            }
            this.inventory.selected = slot.getSlot();
        }
        if (event.getPacketType() == PacketType.Play.Client.CLICK_WINDOW) {
            WrapperPlayClientClickWindow click = new WrapperPlayClientClickWindow(event);
            if (click.getWindowId() != this.openWindowID) {
                return;
            }
            int button = click.getButton();
            int slot = click.getSlot();
            WrapperPlayClientClickWindow.WindowClickType clickType = click.getWindowClickType();
            this.menu.doClick(button, slot, clickType);
        }
        if (event.getPacketType() == PacketType.Play.Client.CLOSE_WINDOW) {
            this.menu = this.inventory;
            this.openWindowID = 0;
            this.menu.setCarried(ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY);
        }
    }

    public void onBlockPlace(BlockPlace place) {
        if (this.player.gamemode != GameMode.CREATIVE && place.getItemStack().getType() != ItemTypes.POWDER_SNOW_BUCKET) {
            place.getItemStack().setAmount(place.getItemStack().getAmount() - 1);
        }
    }

    @Override
    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() == PacketType.Play.Server.OPEN_WINDOW) {
            WrapperPlayServerOpenWindow open = new WrapperPlayServerOpenWindow(event);
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                AbstractContainerMenu newMenu = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_14) ? MenuTypes.getMenuFromID(this.player, this.inventory, open.getType()) : MenuTypes.getMenuFromString(this.player, this.inventory, open.getLegacyType(), open.getLegacySlots(), open.getHorseId());
                this.openWindowID = open.getContainerId();
                this.menu = newMenu;
            });
        }
        if (event.getPacketType() == PacketType.Play.Server.OPEN_HORSE_WINDOW) {
            WrapperPlayServerOpenHorseWindow packet = new WrapperPlayServerOpenHorseWindow(event);
            int windowID = packet.getWindowId();
            int slotCount = packet.getSlotCount();
            int entityID = packet.getEntityId();
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                this.openWindowID = windowID;
                this.menu = new HorseMenu(this.player, this.inventory, slotCount, entityID);
            });
        }
        if (event.getPacketType() == PacketType.Play.Server.CLOSE_WINDOW) {
            if (this.needResend && this.player.bukkitPlayer != null) {
                this.needResend = false;
                Bukkit.getScheduler().runTask((Plugin)GrimAPI.INSTANCE.getPlugin(), () -> {
                    this.player.bukkitPlayer.closeInventory();
                    this.player.bukkitPlayer.updateInventory();
                });
            }
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                this.openWindowID = 0;
                this.menu = this.inventory;
                this.menu.setCarried(ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY);
                this.isPacketInventoryActive = true;
            });
        }
        if (event.getPacketType() == PacketType.Play.Server.WINDOW_ITEMS) {
            WrapperPlayServerWindowItems items = new WrapperPlayServerWindowItems(event);
            this.stateID = items.getStateId();
            if (items.getWindowId() == 0) {
                this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                    if (!this.isPacketInventoryActive) {
                        return;
                    }
                    List<ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack> slots = items.getItems();
                    for (int i = 0; i < slots.size(); ++i) {
                        this.inventory.getSlot(i).set(slots.get(i));
                    }
                    if (items.getCarriedItem().isPresent()) {
                        this.inventory.setCarried(items.getCarriedItem().get());
                    }
                });
            } else {
                this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                    if (!this.isPacketInventoryActive) {
                        return;
                    }
                    if (items.getWindowId() == this.openWindowID) {
                        List<ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack> slots = items.getItems();
                        for (int i = 0; i < slots.size(); ++i) {
                            this.menu.getSlot(i).set(slots.get(i));
                        }
                    }
                    if (items.getCarriedItem().isPresent()) {
                        this.inventory.setCarried(items.getCarriedItem().get());
                    }
                });
            }
        }
        if (event.getPacketType() == PacketType.Play.Server.SET_SLOT) {
            WrapperPlayServerSetSlot slot = new WrapperPlayServerSetSlot(event);
            this.stateID = slot.getStateId();
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                if (!this.isPacketInventoryActive) {
                    return;
                }
                if (slot.getWindowId() == -1) {
                    this.inventory.setCarried(slot.getItem());
                } else if (slot.getWindowId() == -2) {
                    this.inventory.getSlot(slot.getSlot()).set(slot.getItem());
                } else if (slot.getWindowId() == 0) {
                    this.inventory.getSlot(slot.getSlot()).set(slot.getItem());
                } else if (slot.getWindowId() == this.openWindowID) {
                    this.menu.getSlot(slot.getSlot()).set(slot.getItem());
                }
            });
        }
    }
}

