/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.latency;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.potion.PotionType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.potion.PotionTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import ac.grim.grimac.shaded.fastutil.ints.Int2ObjectOpenHashMap;
import ac.grim.grimac.utils.data.ShulkerData;
import ac.grim.grimac.utils.data.TrackerData;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.data.packetentity.PacketEntityHook;
import ac.grim.grimac.utils.data.packetentity.PacketEntityHorse;
import ac.grim.grimac.utils.data.packetentity.PacketEntityRideable;
import ac.grim.grimac.utils.data.packetentity.PacketEntitySelf;
import ac.grim.grimac.utils.data.packetentity.PacketEntityShulker;
import ac.grim.grimac.utils.data.packetentity.PacketEntitySizeable;
import ac.grim.grimac.utils.data.packetentity.PacketEntityStrider;
import ac.grim.grimac.utils.data.packetentity.PacketEntityTrackXRot;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.nmsutil.BoundingBoxSize;
import ac.grim.grimac.utils.nmsutil.WatchableIndexUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class CompensatedEntities {
    private static final UUID SPRINTING_MODIFIER_UUID = UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D");
    public static final UUID SNOW_MODIFIER_UUID = UUID.fromString("1eaf83ff-7207-4596-b37a-d7a07b3ec4ce");
    public final Int2ObjectOpenHashMap<PacketEntity> entityMap = new Int2ObjectOpenHashMap(40, 0.7f);
    public final Int2ObjectOpenHashMap<TrackerData> serverPositionsMap = new Int2ObjectOpenHashMap(40, 0.7f);
    public Integer serverPlayerVehicle = null;
    public boolean hasSprintingAttributeEnabled = false;
    GrimPlayer player;
    public TrackerData selfTrackedEntity;
    public PacketEntitySelf playerEntity;

    public CompensatedEntities(GrimPlayer player) {
        this.player = player;
        this.playerEntity = new PacketEntitySelf(player);
        this.selfTrackedEntity = new TrackerData(0.0, 0.0, 0.0, 0.0f, 0.0f, EntityTypes.PLAYER, player.lastTransactionSent.get());
    }

    public int getPacketEntityID(PacketEntity entity) {
        for (Map.Entry entry : this.entityMap.entrySet()) {
            if (entry.getValue() != entity) continue;
            return (Integer)entry.getKey();
        }
        return Integer.MIN_VALUE;
    }

    public void tick() {
        this.playerEntity.setPositionRaw(this.player.boundingBox);
        for (PacketEntity vehicle : this.entityMap.values()) {
            for (PacketEntity passenger : vehicle.passengers) {
                this.tickPassenger(vehicle, passenger);
            }
        }
    }

    public void removeEntity(int entityID) {
        PacketEntity entity = this.entityMap.remove(entityID);
        if (entity == null) {
            return;
        }
        for (PacketEntity passenger : new ArrayList<PacketEntity>(entity.passengers)) {
            passenger.eject();
        }
    }

    public Integer getJumpAmplifier() {
        return this.getPotionLevelForPlayer(PotionTypes.JUMP_BOOST);
    }

    public Integer getLevitationAmplifier() {
        return this.getPotionLevelForPlayer(PotionTypes.LEVITATION);
    }

    public Integer getSlowFallingAmplifier() {
        return this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_12_2) ? null : this.getPotionLevelForPlayer(PotionTypes.SLOW_FALLING);
    }

    public Integer getDolphinsGraceAmplifier() {
        return this.getPotionLevelForPlayer(PotionTypes.DOLPHINS_GRACE);
    }

    public Integer getPotionLevelForPlayer(PotionType type) {
        PacketEntity desiredEntity = this.playerEntity.getRiding() != null ? this.playerEntity.getRiding() : this.playerEntity;
        HashMap<PotionType, Integer> effects = desiredEntity.potionsMap;
        if (effects == null) {
            return null;
        }
        return effects.get(type);
    }

    public double getPlayerMovementSpeed() {
        return this.calculateAttribute(this.player.compensatedEntities.getSelf().playerSpeed, 0.0, 1024.0);
    }

    public void updateAttributes(int entityID, List<WrapperPlayServerUpdateAttributes.Property> objects) {
        PacketEntity entity;
        if (entityID == this.player.entityID) {
            for (WrapperPlayServerUpdateAttributes.Property snapshotWrapper : objects) {
                if (!snapshotWrapper.getKey().toUpperCase().contains("MOVEMENT")) continue;
                boolean found = false;
                List<WrapperPlayServerUpdateAttributes.PropertyModifier> modifiers = snapshotWrapper.getModifiers();
                for (WrapperPlayServerUpdateAttributes.PropertyModifier modifier : modifiers) {
                    if (!modifier.getUUID().equals(SPRINTING_MODIFIER_UUID)) continue;
                    found = true;
                    break;
                }
                this.hasSprintingAttributeEnabled = found;
                this.player.compensatedEntities.getSelf().playerSpeed = snapshotWrapper;
            }
        }
        if ((entity = this.player.compensatedEntities.getEntity(entityID)) instanceof PacketEntityHorse) {
            for (WrapperPlayServerUpdateAttributes.Property snapshotWrapper : objects) {
                if (snapshotWrapper.getKey().toUpperCase().contains("MOVEMENT")) {
                    ((PacketEntityHorse)entity).movementSpeedAttribute = (float)this.calculateAttribute(snapshotWrapper, 0.0, 1024.0);
                }
                if (!snapshotWrapper.getKey().toUpperCase().contains("JUMP")) continue;
                ((PacketEntityHorse)entity).jumpStrength = this.calculateAttribute(snapshotWrapper, 0.0, 2.0);
            }
        }
        if (entity instanceof PacketEntityRideable) {
            for (WrapperPlayServerUpdateAttributes.Property snapshotWrapper : objects) {
                if (!snapshotWrapper.getKey().toUpperCase().contains("MOVEMENT")) continue;
                ((PacketEntityRideable)entity).movementSpeedAttribute = (float)this.calculateAttribute(snapshotWrapper, 0.0, 1024.0);
            }
        }
    }

    private double calculateAttribute(WrapperPlayServerUpdateAttributes.Property snapshotWrapper, double minValue, double maxValue) {
        double d0 = snapshotWrapper.getValue();
        List<WrapperPlayServerUpdateAttributes.PropertyModifier> modifiers = snapshotWrapper.getModifiers();
        modifiers.removeIf(modifier -> modifier.getUUID().equals(SPRINTING_MODIFIER_UUID));
        for (WrapperPlayServerUpdateAttributes.PropertyModifier attributemodifier : modifiers) {
            if (attributemodifier.getOperation() != WrapperPlayServerUpdateAttributes.PropertyModifier.Operation.ADDITION) continue;
            d0 += attributemodifier.getAmount();
        }
        double d1 = d0;
        for (WrapperPlayServerUpdateAttributes.PropertyModifier attributemodifier : modifiers) {
            if (attributemodifier.getOperation() != WrapperPlayServerUpdateAttributes.PropertyModifier.Operation.MULTIPLY_BASE) continue;
            d1 += d0 * attributemodifier.getAmount();
        }
        for (WrapperPlayServerUpdateAttributes.PropertyModifier attributemodifier : modifiers) {
            if (attributemodifier.getOperation() != WrapperPlayServerUpdateAttributes.PropertyModifier.Operation.MULTIPLY_TOTAL) continue;
            d1 *= 1.0 + attributemodifier.getAmount();
        }
        return GrimMath.clampFloat((float)d1, (float)minValue, (float)maxValue);
    }

    private void tickPassenger(PacketEntity riding, PacketEntity passenger) {
        if (riding == null || passenger == null) {
            return;
        }
        passenger.setPositionRaw(riding.getPossibleCollisionBoxes().offset(0.0, BoundingBoxSize.getMyRidingOffset(riding) + BoundingBoxSize.getPassengerRidingOffset(this.player, passenger), 0.0));
        for (PacketEntity passengerPassenger : riding.passengers) {
            this.tickPassenger(passenger, passengerPassenger);
        }
    }

    public void addEntity(int entityID, EntityType entityType, Vector3d position, float xRot, int data) {
        if (entityType == EntityTypes.ITEM) {
            return;
        }
        PacketEntity packetEntity = EntityTypes.isTypeInstanceOf(entityType, EntityTypes.ABSTRACT_HORSE) ? new PacketEntityHorse(this.player, entityType, position.getX(), position.getY(), position.getZ(), xRot) : (entityType == EntityTypes.SLIME || entityType == EntityTypes.MAGMA_CUBE || entityType == EntityTypes.PHANTOM ? new PacketEntitySizeable(this.player, entityType, position.getX(), position.getY(), position.getZ()) : (EntityTypes.PIG.equals(entityType) ? new PacketEntityRideable(this.player, entityType, position.getX(), position.getY(), position.getZ()) : (EntityTypes.SHULKER.equals(entityType) ? new PacketEntityShulker(this.player, entityType, position.getX(), position.getY(), position.getZ()) : (EntityTypes.STRIDER.equals(entityType) ? new PacketEntityStrider(this.player, entityType, position.getX(), position.getY(), position.getZ()) : (EntityTypes.isTypeInstanceOf(entityType, EntityTypes.BOAT) || EntityTypes.CHICKEN.equals(entityType) ? new PacketEntityTrackXRot(this.player, entityType, position.getX(), position.getY(), position.getZ(), xRot) : (EntityTypes.FISHING_BOBBER.equals(entityType) ? new PacketEntityHook(this.player, entityType, position.getX(), position.getY(), position.getZ(), data) : new PacketEntity(this.player, entityType, position.getX(), position.getY(), position.getZ())))))));
        this.entityMap.put(entityID, packetEntity);
    }

    public PacketEntity getEntity(int entityID) {
        if (entityID == this.player.entityID) {
            return this.playerEntity;
        }
        return this.entityMap.get(entityID);
    }

    public PacketEntitySelf getSelf() {
        return this.playerEntity;
    }

    public TrackerData getTrackedEntity(int id) {
        if (id == this.player.entityID) {
            return this.selfTrackedEntity;
        }
        return this.serverPositionsMap.get(id);
    }

    public void updateEntityMetadata(int entityID, List<EntityData> watchableObjects) {
        Object gravityObject;
        EntityData gravity;
        int offset;
        EntityData sizeObject;
        Object value;
        int id;
        EntityData ageableObject;
        PacketEntity entity = this.player.compensatedEntities.getEntity(entityID);
        if (entity == null) {
            return;
        }
        if (entity.isAgeable() && (ageableObject = WatchableIndexUtil.getIndex(watchableObjects, id = PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_8_8) ? 12 : (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_9_4) ? 11 : (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_13_2) ? 12 : (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_14_4) ? 14 : (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_16_5) ? 15 : 16)))))) != null) {
            value = ageableObject.getValue();
            if (value instanceof Boolean) {
                entity.isBaby = (Boolean)value;
            } else if (value instanceof Byte) {
                boolean bl = entity.isBaby = (Byte)value < 0;
            }
        }
        if (entity.isSize() && (sizeObject = WatchableIndexUtil.getIndex(watchableObjects, id = PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_8_8) ? 16 : (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_9_4) ? 11 : (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_13_2) ? 12 : (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_14_4) ? 14 : (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_16_5) ? 15 : 16)))))) != null) {
            value = sizeObject.getValue();
            if (value instanceof Integer) {
                ((PacketEntitySizeable)entity).size = (Integer)value;
            } else if (value instanceof Byte) {
                ((PacketEntitySizeable)entity).size = ((Byte)value).byteValue();
            }
        }
        if (entity instanceof PacketEntityShulker) {
            EntityData height;
            id = PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_9_4) ? 11 : (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_13_2) ? 12 : (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_14_4) ? 14 : (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_16_5) ? 15 : 16)));
            EntityData shulkerAttached = WatchableIndexUtil.getIndex(watchableObjects, id);
            if (shulkerAttached != null) {
                ((PacketEntityShulker)entity).facing = BlockFace.valueOf(shulkerAttached.getValue().toString().toUpperCase());
            }
            if ((height = WatchableIndexUtil.getIndex(watchableObjects, id + 2)) != null) {
                ShulkerData data;
                if ((Byte)height.getValue() == 0) {
                    data = new ShulkerData(entity, this.player.lastTransactionSent.get(), true);
                    this.player.compensatedWorld.openShulkerBoxes.remove(data);
                    this.player.compensatedWorld.openShulkerBoxes.add(data);
                } else {
                    data = new ShulkerData(entity, this.player.lastTransactionSent.get(), false);
                    this.player.compensatedWorld.openShulkerBoxes.remove(data);
                    this.player.compensatedWorld.openShulkerBoxes.add(data);
                }
            }
        }
        if (entity instanceof PacketEntityRideable) {
            EntityData pigSaddle;
            offset = 0;
            if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_8_8)) {
                if (entity.type == EntityTypes.PIG && (pigSaddle = WatchableIndexUtil.getIndex(watchableObjects, 16)) != null) {
                    ((PacketEntityRideable)entity).hasSaddle = (Byte)pigSaddle.getValue() != 0;
                }
            } else if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_9_4)) {
                offset = 5;
            } else if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_13_2)) {
                offset = 4;
            } else if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_14_4)) {
                offset = 2;
            } else if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_16_5)) {
                offset = 1;
            }
            if (entity.type == EntityTypes.PIG) {
                EntityData pigBoost;
                pigSaddle = WatchableIndexUtil.getIndex(watchableObjects, 17 - offset);
                if (pigSaddle != null) {
                    ((PacketEntityRideable)entity).hasSaddle = (Boolean)pigSaddle.getValue();
                }
                if ((pigBoost = WatchableIndexUtil.getIndex(watchableObjects, 18 - offset)) != null) {
                    ((PacketEntityRideable)entity).boostTimeMax = (Integer)pigBoost.getValue();
                    ((PacketEntityRideable)entity).currentBoostTime = 0;
                }
            } else if (entity instanceof PacketEntityStrider) {
                EntityData striderSaddle;
                EntityData striderBoost = WatchableIndexUtil.getIndex(watchableObjects, 17 - offset);
                if (striderBoost != null) {
                    ((PacketEntityRideable)entity).boostTimeMax = (Integer)striderBoost.getValue();
                    ((PacketEntityRideable)entity).currentBoostTime = 0;
                }
                if ((striderSaddle = WatchableIndexUtil.getIndex(watchableObjects, 19 - offset)) != null) {
                    ((PacketEntityRideable)entity).hasSaddle = (Boolean)striderSaddle.getValue();
                }
            }
        }
        if (entity instanceof PacketEntityHorse) {
            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9_4)) {
                EntityData strength;
                EntityData chestByte;
                offset = 0;
                if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_9_4)) {
                    offset = 5;
                } else if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_13_2)) {
                    offset = 4;
                } else if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_14_4)) {
                    offset = 2;
                } else if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_16_5)) {
                    offset = 1;
                }
                EntityData horseByte = WatchableIndexUtil.getIndex(watchableObjects, 17 - offset);
                if (horseByte != null) {
                    byte info = (Byte)horseByte.getValue();
                    ((PacketEntityHorse)entity).isTame = (info & 2) != 0;
                    ((PacketEntityHorse)entity).hasSaddle = (info & 4) != 0;
                    boolean bl = ((PacketEntityHorse)entity).isRearing = (info & 0x20) != 0;
                }
                if ((chestByte = WatchableIndexUtil.getIndex(watchableObjects, 19 - offset)) != null && chestByte.getValue() instanceof Boolean) {
                    ((PacketEntityHorse)entity).hasChest = (Boolean)chestByte.getValue();
                }
                if ((strength = WatchableIndexUtil.getIndex(watchableObjects, 20 - offset)) != null && strength.getValue() instanceof Integer) {
                    ((PacketEntityHorse)entity).llamaStrength = (Integer)strength.getValue();
                }
            } else {
                EntityData horseByte = WatchableIndexUtil.getIndex(watchableObjects, 16);
                if (horseByte != null) {
                    int info = (Integer)horseByte.getValue();
                    ((PacketEntityHorse)entity).isTame = (info & 2) != 0;
                    ((PacketEntityHorse)entity).hasSaddle = (info & 4) != 0;
                    ((PacketEntityHorse)entity).hasSaddle = (info & 8) != 0;
                    boolean bl = ((PacketEntityHorse)entity).isRearing = (info & 0x40) != 0;
                }
            }
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9_4) && (gravity = WatchableIndexUtil.getIndex(watchableObjects, 5)) != null && (gravityObject = gravity.getValue()) instanceof Boolean) {
            boolean bl = entity.hasGravity = (Boolean)gravityObject == false;
        }
        if (entity.type == EntityTypes.FIREWORK_ROCKET) {
            int offset2 = 0;
            if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_12_2)) {
                offset2 = 2;
            } else if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_16_5)) {
                offset2 = 1;
            }
            EntityData fireworkWatchableObject = WatchableIndexUtil.getIndex(watchableObjects, 9 - offset2);
            if (fireworkWatchableObject == null) {
                return;
            }
            if (fireworkWatchableObject.getValue() instanceof Integer) {
                int attachedEntityID = (Integer)fireworkWatchableObject.getValue();
                if (attachedEntityID == this.player.entityID) {
                    this.player.compensatedFireworks.addNewFirework(entityID);
                }
            } else {
                Optional attachedEntityID = (Optional)fireworkWatchableObject.getValue();
                if (attachedEntityID.isPresent() && ((Integer)attachedEntityID.get()).equals(this.player.entityID)) {
                    this.player.compensatedFireworks.addNewFirework(entityID);
                }
            }
        }
        if (entity instanceof PacketEntityHook) {
            int index = PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_9_4) ? 5 : (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_14_4) ? 6 : (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_16_5) ? 7 : 8));
            EntityData hookWatchableObject = WatchableIndexUtil.getIndex(watchableObjects, index);
            if (hookWatchableObject == null) {
                return;
            }
            Integer attachedEntityID = (Integer)hookWatchableObject.getValue();
            ((PacketEntityHook)entity).attached = attachedEntityID - 1;
        }
    }
}

