/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.inventory.inventory;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.enchantment.Enchantment;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTInt;
import ac.grim.grimac.utils.inventory.EnchantmentHelper;
import ac.grim.grimac.utils.inventory.Inventory;
import ac.grim.grimac.utils.inventory.InventoryStorage;
import ac.grim.grimac.utils.inventory.inventory.AbstractContainerMenu;
import ac.grim.grimac.utils.inventory.slot.Slot;
import java.util.List;
import java.util.stream.Collectors;

public class GrindstoneMenu
extends AbstractContainerMenu {
    public GrindstoneMenu(GrimPlayer player, Inventory playerInventory) {
        super(player, playerInventory);
        final InventoryStorage storage = new InventoryStorage(3);
        this.addSlot(new Slot(storage, 0){

            @Override
            public boolean mayPlace(ItemStack stack) {
                return stack.isDamageableItem() || stack.getType() == ItemTypes.ENCHANTED_BOOK || !stack.isEnchanted(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
            }
        });
        this.addSlot(new Slot(storage, 1){

            @Override
            public boolean mayPlace(ItemStack stack) {
                return stack.isDamageableItem() || stack.getType() == ItemTypes.ENCHANTED_BOOK || !stack.isEnchanted(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
            }
        });
        this.addSlot(new Slot(storage, 2){

            @Override
            public boolean mayPlace(ItemStack p_39630_) {
                return false;
            }

            @Override
            public void onTake(GrimPlayer p_150574_, ItemStack p_150575_) {
                storage.setItem(0, ItemStack.EMPTY);
                storage.setItem(1, ItemStack.EMPTY);
            }
        });
        this.addFourRowPlayerInventory();
    }

    private static int calculateIncreasedRepairCost(int p_39026_) {
        return p_39026_ * 2 + 1;
    }

    private void createResult() {
        boolean flag1;
        ItemStack itemstack = this.getSlot(0).getItem();
        ItemStack itemstack1 = this.getSlot(1).getItem();
        boolean flag = !itemstack.isEmpty() || !itemstack1.isEmpty();
        boolean bl = flag1 = !itemstack.isEmpty() && !itemstack1.isEmpty();
        if (!flag) {
            this.getSlot(0).set(ItemStack.EMPTY);
        } else {
            ItemStack itemstack2;
            int i;
            boolean flag2;
            boolean bl2 = flag2 = !itemstack.isEmpty() && !itemstack.is(ItemTypes.ENCHANTED_BOOK) && !itemstack.isEnchanted(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()) || !itemstack1.isEmpty() && !itemstack1.is(ItemTypes.ENCHANTED_BOOK) && !itemstack1.isEnchanted(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
            if (itemstack.getAmount() > 1 || itemstack1.getAmount() > 1 || !flag1 && flag2) {
                this.getSlot(2).set(ItemStack.EMPTY);
                return;
            }
            int j = 1;
            if (flag1) {
                if (!itemstack.is(itemstack1.getType())) {
                    this.getSlot(2).set(ItemStack.EMPTY);
                    return;
                }
                ItemType item = itemstack.getType();
                int k = item.getMaxDurability() - itemstack.getDamageValue();
                int l = item.getMaxDurability() - itemstack1.getDamageValue();
                int i1 = k + l + item.getMaxDurability() * 5 / 100;
                i = Math.max(item.getMaxDurability() - i1, 0);
                itemstack2 = this.mergeEnchants(itemstack, itemstack1);
                if (!itemstack2.isDamageableItem()) {
                    if (!ItemStack.isSameItemSameTags(itemstack, itemstack1)) {
                        this.getSlot(2).set(ItemStack.EMPTY);
                        return;
                    }
                    j = 2;
                }
            } else {
                boolean flag3 = !itemstack.isEmpty();
                i = flag3 ? itemstack.getDamageValue() : itemstack1.getDamageValue();
                itemstack2 = flag3 ? itemstack : itemstack1;
            }
            this.getSlot(2).set(this.removeNonCurses(itemstack2, i, j));
        }
    }

    private ItemStack mergeEnchants(ItemStack first, ItemStack second) {
        ItemStack copyFirst = first.copy();
        List<Enchantment> enchants = second.getEnchantments(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
        for (Enchantment entry : enchants) {
            if (EnchantmentHelper.isCurse(entry.getType()) && copyFirst.getEnchantmentLevel(entry.getType(), PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()) != 0) continue;
            Enchantment enchant = Enchantment.builder().type(entry.getType()).level(entry.getLevel()).build();
            List<Enchantment> enchantmentList = copyFirst.getEnchantments(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
            enchantmentList.add(enchant);
            copyFirst.setEnchantments(enchantmentList, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
        }
        return copyFirst;
    }

    private ItemStack removeNonCurses(ItemStack itemOne, int p_39581_, int p_39582_) {
        ItemStack itemstack = itemOne.copy();
        itemstack.getNBT().removeTag("Enchantments");
        itemstack.getNBT().removeTag("StoredEnchantments");
        if (p_39581_ > 0) {
            itemstack.setDamageValue(p_39581_);
        } else {
            itemstack.getNBT().removeTag("Damage");
        }
        itemstack.setAmount(p_39582_);
        List<Enchantment> filteredCurses = itemOne.getEnchantments(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()).stream().filter(enchantment -> !EnchantmentHelper.isCurse(enchantment.getType())).collect(Collectors.toList());
        itemstack.setEnchantments(filteredCurses, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
        if (itemstack.is(ItemTypes.ENCHANTED_BOOK) && filteredCurses.size() == 0) {
            itemstack = new ItemStack.Builder().type(ItemTypes.BOOK).amount(1).build();
            if (itemOne.getNBT().getCompoundTagOrNull("display") != null && itemOne.getNBT().getCompoundTagOrNull("display").getTagOrNull("Name") != null) {
                NBTCompound compoundTag = itemstack.getOrCreateTag().getCompoundTagOrNull("display");
                if (compoundTag == null) {
                    itemstack.getNBT().setTag("display", new NBTCompound());
                    compoundTag = itemstack.getNBT().getCompoundTagOrNull("display");
                }
                compoundTag.setTag("Name", itemOne.getNBT().getCompoundTagOrNull("display").getTagOrNull("Name"));
            }
        }
        itemstack.getNBT().setTag("RepairCost", new NBTInt(0));
        for (int i = 0; i < filteredCurses.size(); ++i) {
            itemstack.getNBT().setTag("RepairCost", new NBTInt(GrindstoneMenu.calculateIncreasedRepairCost(itemstack.getNBT().getNumberTagOrNull("RepairCost").getAsInt())));
        }
        return itemstack;
    }

    @Override
    public ItemStack quickMoveStack(int p_39589_) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(p_39589_);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            ItemStack itemstack2 = this.getSlot(0).getItem();
            ItemStack itemstack3 = this.getSlot(1).getItem();
            if (p_39589_ == 2 ? !this.moveItemStackTo(itemstack1, 3, 39, true) : (p_39589_ != 0 && p_39589_ != 1 ? (!itemstack2.isEmpty() && !itemstack3.isEmpty() ? (p_39589_ >= 3 && p_39589_ < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : p_39589_ >= 30 && p_39589_ < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false)) : !this.moveItemStackTo(itemstack1, 0, 2, false)) : !this.moveItemStackTo(itemstack1, 3, 39, false))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            }
            if (itemstack1.getAmount() == itemstack.getAmount()) {
                return ItemStack.EMPTY;
            }
        }
        return itemstack;
    }
}

