/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.inventory.inventory;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import ac.grim.grimac.utils.inventory.BrewingHelper;
import ac.grim.grimac.utils.inventory.Inventory;
import ac.grim.grimac.utils.inventory.InventoryStorage;
import ac.grim.grimac.utils.inventory.inventory.AbstractContainerMenu;
import ac.grim.grimac.utils.inventory.slot.Slot;

public class BrewingMenu
extends AbstractContainerMenu {
    public BrewingMenu(GrimPlayer player, Inventory playerInventory) {
        super(player, playerInventory);
        InventoryStorage containerStorage = new InventoryStorage(4);
        this.addSlot(new PotionSlot(containerStorage, 0));
        this.addSlot(new PotionSlot(containerStorage, 1));
        this.addSlot(new PotionSlot(containerStorage, 2));
        this.addSlot(new IngredientsSlot(containerStorage, 3));
        this.addSlot(new FuelSlot(containerStorage, 0));
        this.addFourRowPlayerInventory();
    }

    @Override
    public ItemStack quickMoveStack(int slotID) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotID);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if ((slotID < 0 || slotID > 2) && slotID != 3 && slotID != 4 ? (FuelSlot.mayPlaceItem(itemstack) ? this.moveItemStackTo(itemstack1, 4, 5, false) || IngredientsSlot.mayPlaceItem(itemstack1) && !this.moveItemStackTo(itemstack1, 3, 4, false) : (IngredientsSlot.mayPlaceItem(itemstack1) ? !this.moveItemStackTo(itemstack1, 3, 4, false) : (PotionSlot.mayPlaceItem(itemstack) && itemstack.getAmount() == 1 ? !this.moveItemStackTo(itemstack1, 0, 3, false) : (slotID >= 5 && slotID < 32 ? !this.moveItemStackTo(itemstack1, 32, 41, false) : (slotID >= 32 && slotID < 41 ? !this.moveItemStackTo(itemstack1, 5, 32, false) : !this.moveItemStackTo(itemstack1, 5, 41, false)))))) : !this.moveItemStackTo(itemstack1, 5, 41, true)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            }
            if (itemstack1.getAmount() == itemstack.getAmount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(this.player, itemstack1);
        }
        return itemstack;
    }

    static class PotionSlot
    extends Slot {
        public PotionSlot(InventoryStorage container, int slot) {
            super(container, slot);
        }

        public static boolean mayPlaceItem(ItemStack p_39134_) {
            return p_39134_.getType().getName().getKey().endsWith("POTION") || p_39134_.getType() == ItemTypes.GLASS_BOTTLE;
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }

        @Override
        public boolean mayPlace(ItemStack p_39132_) {
            return PotionSlot.mayPlaceItem(p_39132_);
        }

        @Override
        public void onTake(GrimPlayer player, ItemStack p_150500_) {
            super.onTake(player, p_150500_);
        }
    }

    static class IngredientsSlot
    extends Slot {
        public IngredientsSlot(InventoryStorage container, int slot) {
            super(container, slot);
        }

        public static boolean mayPlaceItem(ItemStack stack) {
            return BrewingHelper.isBaseModifier(stack.getType()) || BrewingHelper.isEffectIngredient(stack.getType());
        }

        @Override
        public boolean mayPlace(ItemStack p_39121_) {
            return IngredientsSlot.mayPlaceItem(p_39121_);
        }

        @Override
        public int getMaxStackSize() {
            return 64;
        }
    }

    static class FuelSlot
    extends Slot {
        public FuelSlot(InventoryStorage container, int slot) {
            super(container, slot);
        }

        public static boolean mayPlaceItem(ItemStack p_39113_) {
            return p_39113_.getType() == ItemTypes.BLAZE_POWDER;
        }

        @Override
        public boolean mayPlace(ItemStack p_39111_) {
            return FuelSlot.mayPlaceItem(p_39111_);
        }

        @Override
        public int getMaxStackSize() {
            return 64;
        }
    }
}

