/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.data.packetentity;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.potion.PotionType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.ReachInterpolationData;
import ac.grim.grimac.utils.nmsutil.GetBoundingBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PacketEntity {
    public Vector3d desyncClientPos;
    public EntityType type;
    public PacketEntity riding;
    public List<PacketEntity> passengers = new ArrayList<PacketEntity>(0);
    public boolean isDead = false;
    public boolean isBaby = false;
    public boolean hasGravity = true;
    private ReachInterpolationData oldPacketLocation;
    private ReachInterpolationData newPacketLocation;
    public HashMap<PotionType, Integer> potionsMap = null;

    public PacketEntity(EntityType type) {
        this.type = type;
    }

    public PacketEntity(GrimPlayer player, EntityType type, double x, double y, double z) {
        this.desyncClientPos = new Vector3d(x, y, z);
        if (player.getClientVersion().isOlderThan(ClientVersion.V_1_9)) {
            this.desyncClientPos = new Vector3d((double)((int)(this.desyncClientPos.getX() * 32.0)) / 32.0, (double)((int)(this.desyncClientPos.getY() * 32.0)) / 32.0, (double)((int)(this.desyncClientPos.getZ() * 32.0)) / 32.0);
        }
        this.type = type;
        this.newPacketLocation = new ReachInterpolationData(player, GetBoundingBox.getPacketEntityBoundingBox(player, x, y, z, this), this.desyncClientPos.getX(), this.desyncClientPos.getY(), this.desyncClientPos.getZ(), !player.compensatedEntities.getSelf().inVehicle() && player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9), this);
    }

    public boolean isLivingEntity() {
        return EntityTypes.isTypeInstanceOf(this.type, EntityTypes.LIVINGENTITY);
    }

    public boolean isMinecart() {
        return EntityTypes.isTypeInstanceOf(this.type, EntityTypes.MINECART_ABSTRACT);
    }

    public boolean isHorse() {
        return EntityTypes.isTypeInstanceOf(this.type, EntityTypes.ABSTRACT_HORSE);
    }

    public boolean isAgeable() {
        return EntityTypes.isTypeInstanceOf(this.type, EntityTypes.ABSTRACT_AGEABLE);
    }

    public boolean isAnimal() {
        return EntityTypes.isTypeInstanceOf(this.type, EntityTypes.ABSTRACT_ANIMAL);
    }

    public boolean isSize() {
        return this.type == EntityTypes.PHANTOM || this.type == EntityTypes.SLIME || this.type == EntityTypes.MAGMA_CUBE;
    }

    public void onFirstTransaction(boolean relative, boolean hasPos, double relX, double relY, double relZ, GrimPlayer player) {
        if (hasPos) {
            if (relative) {
                this.desyncClientPos = new Vector3d(Math.floor(this.desyncClientPos.getX() * 4096.0) / 4096.0, Math.floor(this.desyncClientPos.getY() * 4096.0) / 4096.0, Math.floor(this.desyncClientPos.getZ() * 4096.0) / 4096.0);
                this.desyncClientPos = this.desyncClientPos.add(new Vector3d(relX, relY, relZ));
            } else {
                this.desyncClientPos = new Vector3d(relX, relY, relZ);
                if (player.getClientVersion().isOlderThan(ClientVersion.V_1_9)) {
                    this.desyncClientPos = new Vector3d((double)((int)(this.desyncClientPos.getX() * 32.0)) / 32.0, (double)((int)(this.desyncClientPos.getY() * 32.0)) / 32.0, (double)((int)(this.desyncClientPos.getZ() * 32.0)) / 32.0);
                }
            }
        }
        this.oldPacketLocation = this.newPacketLocation;
        this.newPacketLocation = new ReachInterpolationData(player, this.oldPacketLocation.getPossibleLocationCombined(), this.desyncClientPos.getX(), this.desyncClientPos.getY(), this.desyncClientPos.getZ(), !player.compensatedEntities.getSelf().inVehicle() && player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9), this);
    }

    public void onSecondTransaction() {
        this.oldPacketLocation = null;
    }

    public void onMovement(boolean tickingReliably) {
        this.newPacketLocation.tickMovement(this.oldPacketLocation == null, tickingReliably);
        if (this.oldPacketLocation != null) {
            this.oldPacketLocation.tickMovement(true, tickingReliably);
            this.newPacketLocation.updatePossibleStartingLocation(this.oldPacketLocation.getPossibleLocationCombined());
        }
    }

    public boolean hasPassenger(PacketEntity entity) {
        return this.passengers.contains(entity);
    }

    public void mount(PacketEntity vehicle) {
        if (this.riding != null) {
            this.eject();
        }
        vehicle.passengers.add(this);
        this.riding = vehicle;
    }

    public void eject() {
        if (this.riding != null) {
            this.riding.passengers.remove(this);
        }
        this.riding = null;
    }

    public void setPositionRaw(SimpleCollisionBox box) {
        this.desyncClientPos = new Vector3d((box.maxX - box.minX) / 2.0 + box.minX, box.minY, (box.maxZ - box.minZ) / 2.0 + box.minZ);
        this.newPacketLocation = new ReachInterpolationData(box);
    }

    public SimpleCollisionBox getPossibleCollisionBoxes() {
        if (this.oldPacketLocation == null) {
            return this.newPacketLocation.getPossibleLocationCombined();
        }
        return ReachInterpolationData.combineCollisionBox(this.oldPacketLocation.getPossibleLocationCombined(), this.newPacketLocation.getPossibleLocationCombined());
    }

    public PacketEntity getRiding() {
        return this.riding;
    }

    public void addPotionEffect(PotionType effect, int amplifier) {
        if (this.potionsMap == null) {
            this.potionsMap = new HashMap();
        }
        this.potionsMap.put(effect, amplifier);
    }

    public void removePotionEffect(PotionType effect) {
        if (this.potionsMap == null) {
            return;
        }
        this.potionsMap.remove(effect);
    }
}

