/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.data;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.nmsutil.BoundingBoxSize;
import ac.grim.grimac.utils.nmsutil.GetBoundingBox;

public class ReachInterpolationData {
    private final SimpleCollisionBox targetLocation;
    private SimpleCollisionBox startingLocation;
    private int interpolationStepsLowBound = 0;
    private int interpolationStepsHighBound = 0;
    private int interpolationSteps = 1;

    public ReachInterpolationData(GrimPlayer player, SimpleCollisionBox startingLocation, double x, double y, double z, boolean isPointNine, PacketEntity entity) {
        this.startingLocation = startingLocation;
        this.targetLocation = GetBoundingBox.getBoundingBoxFromPosAndSize(x, y, z, BoundingBoxSize.getWidth(player, entity), BoundingBoxSize.getHeight(player, entity));
        if (!isPointNine && PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
            this.targetLocation.expand(0.03125);
        }
        this.interpolationSteps = EntityTypes.isTypeInstanceOf(entity.type, EntityTypes.BOAT) ? 10 : (EntityTypes.isTypeInstanceOf(entity.type, EntityTypes.MINECART_ABSTRACT) ? 5 : (entity.type == EntityTypes.SHULKER ? 1 : (EntityTypes.isTypeInstanceOf(entity.type, EntityTypes.LIVINGENTITY) ? 3 : 1)));
        if (isPointNine) {
            this.interpolationStepsHighBound = this.getInterpolationSteps();
        }
    }

    public ReachInterpolationData(SimpleCollisionBox finishedLoc) {
        this.startingLocation = finishedLoc;
        this.targetLocation = finishedLoc;
    }

    private int getInterpolationSteps() {
        return this.interpolationSteps;
    }

    public static SimpleCollisionBox combineCollisionBox(SimpleCollisionBox one, SimpleCollisionBox two) {
        double minX = Math.min(one.minX, two.minX);
        double maxX = Math.max(one.maxX, two.maxX);
        double minY = Math.min(one.minY, two.minY);
        double maxY = Math.max(one.maxY, two.maxY);
        double minZ = Math.min(one.minZ, two.minZ);
        double maxZ = Math.max(one.maxZ, two.maxZ);
        return new SimpleCollisionBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public SimpleCollisionBox getPossibleLocationCombined() {
        int interpSteps = this.getInterpolationSteps();
        double stepMinX = (this.targetLocation.minX - this.startingLocation.minX) / (double)interpSteps;
        double stepMaxX = (this.targetLocation.maxX - this.startingLocation.maxX) / (double)interpSteps;
        double stepMinY = (this.targetLocation.minY - this.startingLocation.minY) / (double)interpSteps;
        double stepMaxY = (this.targetLocation.maxY - this.startingLocation.maxY) / (double)interpSteps;
        double stepMinZ = (this.targetLocation.minZ - this.startingLocation.minZ) / (double)interpSteps;
        double stepMaxZ = (this.targetLocation.maxZ - this.startingLocation.maxZ) / (double)interpSteps;
        SimpleCollisionBox minimumInterpLocation = new SimpleCollisionBox(this.startingLocation.minX + (double)this.interpolationStepsLowBound * stepMinX, this.startingLocation.minY + (double)this.interpolationStepsLowBound * stepMinY, this.startingLocation.minZ + (double)this.interpolationStepsLowBound * stepMinZ, this.startingLocation.maxX + (double)this.interpolationStepsLowBound * stepMaxX, this.startingLocation.maxY + (double)this.interpolationStepsLowBound * stepMaxY, this.startingLocation.maxZ + (double)this.interpolationStepsLowBound * stepMaxZ);
        for (int step = this.interpolationStepsLowBound + 1; step <= this.interpolationStepsHighBound; ++step) {
            minimumInterpLocation = ReachInterpolationData.combineCollisionBox(minimumInterpLocation, new SimpleCollisionBox(this.startingLocation.minX + (double)step * stepMinX, this.startingLocation.minY + (double)step * stepMinY, this.startingLocation.minZ + (double)step * stepMinZ, this.startingLocation.maxX + (double)step * stepMaxX, this.startingLocation.maxY + (double)step * stepMaxY, this.startingLocation.maxZ + (double)step * stepMaxZ));
        }
        return minimumInterpLocation;
    }

    public void updatePossibleStartingLocation(SimpleCollisionBox possibleLocationCombined) {
        this.startingLocation = ReachInterpolationData.combineCollisionBox(this.startingLocation, possibleLocationCombined);
    }

    public void tickMovement(boolean incrementLowBound, boolean tickingReliably) {
        if (!tickingReliably) {
            this.interpolationStepsHighBound = this.getInterpolationSteps();
        }
        if (incrementLowBound) {
            this.interpolationStepsLowBound = Math.min(this.interpolationStepsLowBound + 1, this.getInterpolationSteps());
        }
        this.interpolationStepsHighBound = Math.min(this.interpolationStepsHighBound + 1, this.getInterpolationSteps());
    }

    public String toString() {
        return "ReachInterpolationData{targetLocation=" + this.targetLocation + ", startingLocation=" + this.startingLocation + ", interpolationStepsLowBound=" + this.interpolationStepsLowBound + ", interpolationStepsHighBound=" + this.interpolationStepsHighBound + '}';
    }
}

